/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class CacheRateLimiterConfig {
    public final String name;
    public final Long maxAverageRequests;
    public final Long maxSpikeRequests;
    public final Integer numIntervals;
    public final Integer bucketTimeInterval;
    public final int bucketIntervalMs;
    public final TimeUnit unit;
    public final Duration expiration;

    public CacheRateLimiterConfig(String name, Long maxAverageRequests, Long maxSpikeRequests, Integer numIntervals, Integer bucketTimeInterval, TimeUnit unit) {
        this.name = name;
        this.maxAverageRequests = maxAverageRequests;
        this.maxSpikeRequests = maxSpikeRequests;
        this.numIntervals = numIntervals;
        this.bucketTimeInterval = bucketTimeInterval;
        this.bucketIntervalMs = Math.toIntExact(unit.toMillis(bucketTimeInterval.intValue()));
        this.unit = unit;
        this.expiration = Duration.ofMillis(this.bucketIntervalMs * (numIntervals + 1));
    }

    public static class CacheRateLimiterConfigBuilder {
        public final String name;
        public Long maxAverageRequests;
        public Long maxSpikeRequests;
        public Integer numIntervals;
        public Integer bucketTimeInterval;
        public TimeUnit unit;

        public CacheRateLimiterConfigBuilder(String name) {
            this.name = name;
        }

        public CacheRateLimiterConfigBuilder setMaxAverageRequests(long maxAverageRequests) {
            this.maxAverageRequests = maxAverageRequests;
            return this;
        }

        public CacheRateLimiterConfigBuilder setMaxSpikeRequests(long maxSpikeRequests) {
            this.maxSpikeRequests = maxSpikeRequests;
            return this;
        }

        public CacheRateLimiterConfigBuilder setNumIntervals(int numIntervals) {
            this.numIntervals = numIntervals;
            return this;
        }

        public CacheRateLimiterConfigBuilder setBucketTimeInterval(int bucketTimeInterval, TimeUnit unit) {
            this.bucketTimeInterval = bucketTimeInterval;
            this.unit = unit;
            return this;
        }

        public CacheRateLimiterConfig build() {
            return new CacheRateLimiterConfig(this.name, this.maxAverageRequests, this.maxSpikeRequests, this.numIntervals, this.bucketTimeInterval, this.unit);
        }
    }
}

