/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.opencensus.adapter;

import io.datarouter.instrumentation.trace.Trace2BundleAndHttpRequestRecordDto;
import io.datarouter.instrumentation.trace.Trace2BundleDto;
import io.datarouter.instrumentation.trace.Trace2SpanDto;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.Traceparent;
import io.datarouter.scanner.Scanner;
import io.datarouter.trace.conveyor.local.Trace2ForLocalFilterToMemoryBuffer;
import io.datarouter.trace.conveyor.publisher.Trace2ForPublisherFilterToMemoryBuffer;
import io.opencensus.common.Timestamp;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterOpencensusTraceExporter
extends SpanExporter.Handler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterOpencensusTraceExporter.class);
    @Inject
    private Trace2ForLocalFilterToMemoryBuffer trace2BufferForLocal;
    @Inject
    private Trace2ForPublisherFilterToMemoryBuffer trace2BufferForPublisher;

    public void export(Collection<SpanData> spanDataList) {
        logger.info("DatarouterOpencensusTraceExporter starts exporting spanData from opencensus");
        Map bindingSpans = Scanner.of(spanDataList).include(spanData -> spanData.getAttributes().getAttributeMap().containsKey("datarouterTraceparent")).toMap(spanData -> spanData.getContext().getSpanId());
        if (bindingSpans.isEmpty()) {
            logger.info("no binding spans found.");
            return;
        }
        Map parents = Scanner.of(spanDataList).exclude(span -> span.getParentSpanId() == null).toMap(span -> span.getContext().getSpanId(), SpanData::getParentSpanId);
        HashMap sequenceByThreadIdByTraceparent = new HashMap();
        HashMap sequenceBySpanId = new HashMap();
        Scanner.of(spanDataList).exclude(spanData -> bindingSpans.containsKey(spanData.getContext().getSpanId())).map(spanData -> {
            SpanData bindingSpan = (SpanData)bindingSpans.get(DatarouterOpencensusTraceExporter.findBindingSpan(spanData.getContext().getSpanId(), parents));
            if (bindingSpan == null) {
                logger.info("No binding span for: " + spanData);
                return null;
            }
            Map attributes = bindingSpan.getAttributes().getAttributeMap();
            Traceparent traceparent = (Traceparent)Traceparent.parse((String)((String)DatarouterOpencensusTraceExporter.getInnerValue((AttributeValue)attributes.get("datarouterTraceparent")))).get();
            Long threadId = (Long)DatarouterOpencensusTraceExporter.getInnerValue((AttributeValue)attributes.get("datarouterThreadId"));
            Function<SpanId, Integer> nextSequenceGenerator = $ -> sequenceByThreadIdByTraceparent.computeIfAbsent(traceparent, $$ -> new HashMap()).compute(threadId, ($$, old) -> old == null ? 10000 : old + 1);
            Integer sequenceParent = bindingSpan.getContext().getSpanId().equals((Object)spanData.getParentSpanId()) ? Integer.valueOf(DatarouterOpencensusTraceExporter.getIntegerValue((AttributeValue)attributes.get("datarouterSequenceParent"))) : sequenceBySpanId.computeIfAbsent(spanData.getParentSpanId(), nextSequenceGenerator);
            Integer sequence = sequenceBySpanId.computeIfAbsent(spanData.getContext().getSpanId(), nextSequenceGenerator);
            return new Trace2SpanDto(traceparent, threadId, sequence, sequenceParent, spanData.getName(), TraceSpanGroupType.DATABASE, null, DatarouterOpencensusTraceExporter.toNanoTimestamp(DatarouterOpencensusTraceExporter.toInstant(spanData.getStartTimestamp())), DatarouterOpencensusTraceExporter.toNanoTimestamp(DatarouterOpencensusTraceExporter.toInstant(spanData.getEndTimestamp())));
        }).include(Objects::nonNull).groupBy(Trace2SpanDto::getTraceparent).values().stream().map(spans -> new Trace2BundleDto(null, List.of(), (Collection)spans)).map(bundleDto -> new Trace2BundleAndHttpRequestRecordDto(bundleDto, null)).peek(arg_0 -> ((Trace2ForLocalFilterToMemoryBuffer)this.trace2BufferForLocal).offer(arg_0)).forEach(arg_0 -> ((Trace2ForPublisherFilterToMemoryBuffer)this.trace2BufferForPublisher).offer(arg_0));
    }

    private static int getIntegerValue(AttributeValue attributeValue) {
        return ((Long)DatarouterOpencensusTraceExporter.getInnerValue(attributeValue)).intValue();
    }

    private static <T> T getInnerValue(AttributeValue attributeValue) {
        return (T)attributeValue.match(x -> x, x -> x, x -> x, x -> x, x -> x);
    }

    private static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    private static SpanId findBindingSpan(SpanId spanId, Map<SpanId, SpanId> parents) {
        SpanId bindingSpan = spanId;
        while (parents.containsKey(bindingSpan)) {
            bindingSpan = parents.get(bindingSpan);
        }
        return bindingSpan;
    }

    private static Long toNanoTimestamp(Instant instant) {
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }
}

