/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.util;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.encoding.StringEncodedField;
import io.datarouter.util.net.UrlTool;
import io.datarouter.util.string.StringTool;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PercentFieldCodec {
    private static final char CHAR_INTERNAL_SEPARATOR = '/';
    public static final String INTERNAL_SEPARATOR = Character.toString('/');
    private static final char CHAR_ENCODED_SPACE = '+';
    private static final char CHAR_ENCODED_DASH = '-';
    private static final char CHAR_ENCODED_UNDERSCORE = '_';
    private static final char CHAR_ENCODED_DOT = '.';
    private static final char CHAR_ENCODED_STAR = '*';
    private static final Set<Character> ILLEGAL_EXTERNAL_SEPARATORS = new HashSet<Character>();

    static {
        char c = 'A';
        while (c <= 'Z') {
            ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf(c));
            c = (char)(c + 1);
        }
        c = 'a';
        while (c <= 'z') {
            ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        c = '0';
        while (c <= '9') {
            ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf(c));
            c = (char)(c + '\u0001');
        }
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('/'));
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('+'));
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('-'));
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('_'));
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('.'));
        ILLEGAL_EXTERNAL_SEPARATORS.add(Character.valueOf('*'));
    }

    public static boolean isValidExternalSeparator(char separator) {
        return !ILLEGAL_EXTERNAL_SEPARATORS.contains(Character.valueOf(separator));
    }

    public static String encodeFields(List<Field<?>> fields) {
        Stream<String> fieldValues = fields.stream().map(StringEncodedField::getStringEncodedValue);
        return PercentFieldCodec.encode(fieldValues);
    }

    public static String encode(Stream<String> strings) {
        return strings.map(PercentFieldCodec::encodeFragment).collect(Collectors.joining(INTERNAL_SEPARATOR));
    }

    private static String encodeFragment(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("exception encoding " + value, e);
        }
    }

    public static List<String> decode(String encoded) {
        ArrayList eachEncoded = StringTool.splitOnCharNoRegex((String)encoded, (char)'/');
        return eachEncoded.stream().map(UrlTool::decode).collect(Collectors.toList());
    }
}

