/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.util;

import io.datarouter.util.bytes.ByteTool;
import java.util.Arrays;

public class Bytes
implements Comparable<Bytes> {
    public static final Bytes EMPTY = new Bytes(new byte[0]);
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public Bytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Bytes(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] toArray() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Bytes)) {
            return false;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        Bytes other = (Bytes)thatObject;
        int thisTo = this.offset + this.length;
        int otherTo = other.offset + other.length;
        return Arrays.equals(this.bytes, this.offset, thisTo, other.bytes, other.offset, otherTo);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.length) {
            result = 31 * result + this.bytes[this.offset + i];
            ++i;
        }
        return result;
    }

    @Override
    public int compareTo(Bytes other) {
        int thisTo = this.offset + this.length;
        int otherTo = other.offset + other.length;
        return Arrays.compareUnsigned(this.bytes, this.offset, thisTo, other.bytes, other.offset, otherTo);
    }

    public String toString() {
        return ByteTool.getIntString((byte[])this.toArray());
    }
}

