/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.serialize.fielder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.StringDatabeanCodec;
import io.datarouter.model.serialize.codec.JsonDatabeanCodec;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.model.serialize.fielder.FielderConfigKey;
import io.datarouter.model.serialize.fielder.FielderConfigValue;
import io.datarouter.util.lang.ReflectionTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public abstract class BaseDatabeanFielder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
implements DatabeanFielder<PK, D> {
    private final Fielder<PK> primaryKeyFielder;
    private final StringDatabeanCodec stringDatabeanCodec;
    private final Map<FielderConfigKey<?>, FielderConfigValue<?>> configuration;

    protected BaseDatabeanFielder(Class<? extends Fielder<PK>> primaryKeyFielderClass) {
        this.primaryKeyFielder = (Fielder)ReflectionTool.create(primaryKeyFielderClass);
        this.stringDatabeanCodec = (StringDatabeanCodec)ReflectionTool.create(this.getStringDatabeanCodecClass());
        this.configuration = new HashMap();
        this.configure();
    }

    @Override
    public Fielder<PK> getKeyFielder() {
        return this.primaryKeyFielder;
    }

    @Override
    public List<Field<?>> getKeyFields(D databean) {
        return FieldTool.prependPrefixes(databean.getKeyFieldName(), this.primaryKeyFielder.getFields(databean.getKey()));
    }

    @Override
    public List<Field<?>> getFields(D databean) {
        ArrayList allFields = new ArrayList();
        allFields.addAll(this.getKeyFields(databean));
        allFields.addAll(this.getNonKeyFields(databean));
        return allFields;
    }

    @Override
    public Map<String, List<Field<?>>> getUniqueIndexes(D databean) {
        return new TreeMap();
    }

    @Override
    public final void addOption(FielderConfigValue<?> fielderConfigValue) {
        this.configuration.put(fielderConfigValue.getKey(), fielderConfigValue);
    }

    @Override
    public final <T extends FielderConfigValue<T>> Optional<T> getOption(FielderConfigKey<T> key) {
        return Optional.ofNullable(this.configuration.get(key));
    }

    @Override
    public Collection<FielderConfigValue<?>> getOptions() {
        return this.configuration.values();
    }

    @Override
    public Class<? extends StringDatabeanCodec> getStringDatabeanCodecClass() {
        return JsonDatabeanCodec.class;
    }

    @Override
    public final StringDatabeanCodec getStringDatabeanCodec() {
        return this.stringDatabeanCodec;
    }

    @Override
    public Optional<Long> getTtlMs() {
        return Optional.empty();
    }
}

