/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.serialize.codec;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import java.util.Map;
import java.util.function.Supplier;

public class BinaryDatabeanCodec {
    private final int databeanSchemaVersion;

    private BinaryDatabeanCodec(int databeanSchemaVersion) {
        this.databeanSchemaVersion = databeanSchemaVersion;
    }

    public byte[] encode(PrimaryKey<?> pk) {
        byte[] key = FieldTool.getConcatenatedValueBytes(pk.getFields());
        byte[] schemaVersion = IntegerByteTool.getRawBytes((int)this.databeanSchemaVersion);
        return ByteTool.concatenate((byte[][])new byte[][]{schemaVersion, key});
    }

    public <D> D decode(Supplier<D> supplier, Map<String, Field<?>> fieldByPrefixedName, byte[] bytes) {
        return FieldSetTool.fieldSetFromBytes(supplier, fieldByPrefixedName, bytes);
    }

    public static class BinaryDatabeanCodecBuilder {
        private int databeanVersion = 1;

        public BinaryDatabeanCodecBuilder setDatabeanVersion(int databeanVersion) {
            this.databeanVersion = databeanVersion;
            return this;
        }

        public BinaryDatabeanCodec build() {
            return new BinaryDatabeanCodec(this.databeanVersion);
        }
    }
}

