/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.serialize;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.util.bytes.StringByteTool;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public interface StringDatabeanCodec {
    public static final Charset CHARSET = StandardCharsets.UTF_8;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> String toString(D var1, F var2);

    default public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> byte[] toBytes(D databean, F fielder) {
        return this.toString(databean, fielder).getBytes(CHARSET);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> D fromString(String var1, F var2, Supplier<D> var3);

    public String getCollectionSeparator();

    public String getCollectionPrefix();

    public String getCollectionSuffix();

    default public byte[] getCollectionSeparatorBytes() {
        return this.getCollectionSeparator().getBytes(CHARSET);
    }

    default public byte[] getCollectionPrefixBytes() {
        return this.getCollectionPrefix().getBytes(CHARSET);
    }

    default public byte[] getCollectionSuffixBytes() {
        return this.getCollectionSuffix().getBytes(CHARSET);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> List<D> fromStringMulti(String var1, F var2, Supplier<D> var3);

    default public List<List<byte[]>> makeGroups(List<byte[]> encodedDatabeans, int maxBoundedBytesPerMessage) {
        ArrayList<List<byte[]>> groups = new ArrayList<List<byte[]>>();
        ArrayList<byte[]> group = new ArrayList<byte[]>();
        int groupLengthWithoutSeparators = 0;
        for (byte[] encodedDatabean : encodedDatabeans) {
            int totalGroupLength = groupLengthWithoutSeparators + encodedDatabean.length + this.getCollectionSeparatorBytes().length * group.size();
            if (totalGroupLength > maxBoundedBytesPerMessage) {
                groups.add(group);
                group = new ArrayList();
                groupLengthWithoutSeparators = 0;
            }
            group.add(encodedDatabean);
            groupLengthWithoutSeparators += encodedDatabean.length;
        }
        if (!group.isEmpty()) {
            groups.add(group);
        }
        return groups;
    }

    default public String concatGroup(List<byte[]> group) {
        ByteArrayOutputStream databeanGroup = new ByteArrayOutputStream();
        databeanGroup.write(this.getCollectionPrefixBytes(), 0, this.getCollectionPrefixBytes().length);
        int i = 0;
        while (i < group.size()) {
            databeanGroup.write(group.get(i), 0, group.get(i).length);
            if (i < group.size() - 1) {
                databeanGroup.write(this.getCollectionSeparatorBytes(), 0, this.getCollectionSeparatorBytes().length);
            }
            ++i;
        }
        databeanGroup.write(this.getCollectionSuffixBytes(), 0, this.getCollectionSuffixBytes().length);
        return StringByteTool.fromUtf8Bytes((byte[])databeanGroup.toByteArray());
    }
}

