/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.util.lang.ReflectionTool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class JsonDatabeanTool {
    public static <PK extends PrimaryKey<PK>> JsonObject primaryKeyToJson(PK pk, Fielder<PK> fielder) {
        if (pk == null) {
            return null;
        }
        return JsonDatabeanTool.fieldsToJson(fielder.getFields(pk));
    }

    public static <PK extends PrimaryKey<PK>> JsonArray primaryKeysToJson(Iterable<PK> pks, Fielder<PK> fielder) {
        JsonArray array = new JsonArray();
        for (PrimaryKey pk : pks) {
            array.add((JsonElement)JsonDatabeanTool.addFieldsToJsonObject(new JsonObject(), fielder.getFields(pk)));
        }
        return array;
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> JsonObject databeanToJson(D databean, DatabeanFielder<PK, D> fielder) {
        return JsonDatabeanTool.databeanToJson(databean, fielder, false);
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> JsonObject databeanToJson(D databean, DatabeanFielder<PK, D> fielder, boolean flatKey) {
        if (databean == null) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        if (flatKey) {
            JsonDatabeanTool.addFieldsToJsonObject(jsonObject, fielder.getKeyFields(databean));
        } else {
            jsonObject.add(databean.getKeyFieldName(), (JsonElement)JsonDatabeanTool.primaryKeyToJson(databean.getKey(), fielder.getKeyFielder()));
        }
        JsonDatabeanTool.addFieldsToJsonObject(jsonObject, fielder.getNonKeyFields(databean));
        return jsonObject;
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> String databeanToJsonString(D databean, DatabeanFielder<PK, D> fielder) {
        return JsonDatabeanTool.databeanToJsonString(databean, fielder, false);
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> String databeanToJsonString(D databean, DatabeanFielder<PK, D> fielder, boolean flatKey) {
        return JsonDatabeanTool.databeanToJson(databean, fielder, flatKey).toString();
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> JsonArray databeansToJson(Iterable<D> databeans, DatabeanFielder<PK, D> fielder) {
        JsonArray array = new JsonArray();
        for (Databean databean : databeans) {
            array.add((JsonElement)JsonDatabeanTool.databeanToJson(databean, fielder));
        }
        return array;
    }

    public static <PK extends PrimaryKey<PK>> PK primaryKeyFromJson(Class<PK> pkClass, Fielder<PK> fielder, JsonObject json) {
        if (json == null) {
            return null;
        }
        PrimaryKey pk = (PrimaryKey)ReflectionTool.create(pkClass);
        JsonDatabeanTool.primaryKeyFromJson(pk, fielder, json);
        return (PK)pk;
    }

    private static <PK extends PrimaryKey<PK>> void primaryKeyFromJson(PK pk, Fielder<PK> fielder, JsonObject json) {
        if (json == null) {
            return;
        }
        List<Field<?>> fields = fielder.getFields(pk);
        for (Field<?> field : fields) {
            String jsonFieldName = field.getKey().getColumnName();
            JsonElement jsonValue = json.get(jsonFieldName);
            if (jsonValue == null || jsonValue instanceof JsonNull) {
                throw new IllegalStateException(json + " does not contain required key " + jsonFieldName);
            }
            Object value = field.parseStringEncodedValueButDoNotSet(jsonValue.getAsString());
            field.setUsingReflection(pk, value);
        }
    }

    public static <PK extends PrimaryKey<PK>> List<PK> primaryKeysFromJson(Class<PK> pkClass, Fielder<PK> fielder, JsonArray json) {
        ArrayList<PrimaryKey> pks = new ArrayList<PrimaryKey>();
        if (json == null) {
            return pks;
        }
        Iterator iter = json.iterator();
        while (iter.hasNext()) {
            JsonObject jsonPk = ((JsonElement)iter.next()).getAsJsonObject();
            PrimaryKey pk = (PrimaryKey)ReflectionTool.create(pkClass);
            JsonDatabeanTool.primaryKeyFromJson(pk, fielder, jsonPk);
            pks.add(pk);
        }
        return pks;
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> D databeanFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, JsonObject json) {
        return JsonDatabeanTool.databeanFromJson(databeanSupplier, fielder, json, false);
    }

    private static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> D databeanFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, JsonObject json, boolean flatKey) {
        if (json == null) {
            return null;
        }
        Databean databean = (Databean)databeanSupplier.get();
        JsonObject pkJson = flatKey ? json : json.getAsJsonObject(databean.getKeyFieldName());
        JsonDatabeanTool.primaryKeyFromJson(databean.getKey(), fielder.getKeyFielder(), pkJson);
        List<Field<?>> fields = fielder.getNonKeyFields(databean);
        for (Field<?> field : fields) {
            String jsonFieldName = field.getKey().getColumnName();
            JsonElement jsonValue = json.get(jsonFieldName);
            if (jsonValue == null || jsonValue.isJsonNull()) continue;
            String valueString = jsonValue.isJsonObject() ? jsonValue.toString() : jsonValue.getAsString();
            Object value = field.parseStringEncodedValueButDoNotSet(valueString);
            field.setUsingReflection(databean, value);
        }
        return (D)databean;
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> D databeanFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, String json) {
        return JsonDatabeanTool.databeanFromJson(databeanSupplier, fielder, json, false);
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> D databeanFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, String json, boolean flatKey) {
        return JsonDatabeanTool.databeanFromJson(databeanSupplier, fielder, JsonDatabeanTool.stringToJsonObject(json), flatKey);
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> List<D> databeansFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, JsonArray json) {
        ArrayList<D> databeans = new ArrayList<D>();
        if (json == null) {
            return databeans;
        }
        Iterator iter = json.iterator();
        while (iter.hasNext()) {
            JsonObject jsonDatabean = ((JsonElement)iter.next()).getAsJsonObject();
            D databean = JsonDatabeanTool.databeanFromJson(databeanSupplier, fielder, jsonDatabean);
            databeans.add(databean);
        }
        return databeans;
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> List<D> databeansFromJson(Supplier<D> databeanSupplier, DatabeanFielder<PK, D> fielder, String json) {
        return JsonDatabeanTool.databeansFromJson(databeanSupplier, fielder, JsonDatabeanTool.stringToJsonArray(json));
    }

    public static JsonObject stringToJsonObject(String string) {
        return JsonParser.parseString((String)string).getAsJsonObject();
    }

    private static JsonArray stringToJsonArray(String string) {
        return JsonParser.parseString((String)string).getAsJsonArray();
    }

    public static JsonObject fieldsToJson(List<Field<?>> fields) {
        JsonObject jsonObject = new JsonObject();
        JsonDatabeanTool.addFieldsToJsonObject(jsonObject, fields);
        return jsonObject;
    }

    private static JsonObject addFieldsToJsonObject(JsonObject jsonObject, List<Field<?>> fields) {
        for (Field<?> f : fields) {
            jsonObject.addProperty(f.getKey().getColumnName(), f.getStringEncodedValue());
        }
        return jsonObject;
    }
}

