/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.key.primary;

import io.datarouter.model.field.Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.util.tuple.Range;
import java.util.Objects;

public class EntityPrimaryKeyTool {
    public static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>> boolean isSingleEntity(Range<PK> pkRange) {
        Range<EK> ekRange = EntityPrimaryKeyTool.getEkRange(pkRange);
        return ekRange.hasStart() && ekRange.equalsStartEnd() && EntityPrimaryKeyTool.isEntityFullyDefined((EntityKey)ekRange.getStart());
    }

    private static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>> Range<EK> getEkRange(Range<PK> pkRange) {
        Comparable start = pkRange.hasStart() ? (Comparable)((EntityPrimaryKey)pkRange.getStart()).getEntityKey() : null;
        Comparable end = pkRange.hasEnd() ? (Comparable)((EntityPrimaryKey)pkRange.getEnd()).getEntityKey() : null;
        return new Range(start, true, end, true);
    }

    public static <EK extends EntityKey<EK>> boolean isEntityFullyDefined(EK ek) {
        return ek.getFields().stream().map(Field::getValue).noneMatch(Objects::isNull);
    }
}

