/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.key.entity.base;

import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseEntityPartitioner<EK extends EntityKey<EK>>
implements EntityPartitioner<EK> {
    private static final int MIN_PARTITIONS = 1;
    private static final int MAX_ONE_BYTE_NUM_PARTITIONS = 256;
    private static final int MAX_PARTITIONS = 65536;
    private final int numPartitions;
    private final List<Integer> allPartitions;
    private final ArrayList<byte[]> allPrefixes;
    private final byte[][] allPrefixesArray;

    public BaseEntityPartitioner(int numPartitions) {
        this.numPartitions = numPartitions;
        this.allPartitions = new ArrayList<Integer>();
        int i = 0;
        while (i < numPartitions) {
            this.allPartitions.add(i);
            ++i;
        }
        this.allPrefixes = new ArrayList();
        if (numPartitions == 1) {
            this.allPrefixes.add(new byte[0]);
        } else {
            i = 0;
            while (i < numPartitions) {
                this.allPrefixes.add(this.getPrefix(i));
                ++i;
            }
        }
        this.allPrefixesArray = new byte[this.allPrefixes.size()][];
        i = 0;
        while (i < this.allPrefixes.size()) {
            this.allPrefixesArray[i] = this.allPrefixes.get(i);
            ++i;
        }
    }

    @Override
    public final int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public List<Integer> getAllPartitions() {
        return this.allPartitions;
    }

    @Override
    public boolean isLastPartition(int partition) {
        return partition == this.numPartitions - 1;
    }

    @Override
    public int getNumPrefixBytes() {
        return BaseEntityPartitioner.getNumPrefixBytesStatic(this.numPartitions);
    }

    @Override
    public List<byte[]> getAllPrefixes() {
        return this.allPrefixes;
    }

    @Override
    public byte[][] getAllPrefixesArray() {
        return this.allPrefixesArray;
    }

    @Override
    public byte[] getPrefix(int partition) {
        byte[] fourBytePrefix = IntegerByteTool.getRawBytes((int)partition);
        int numPrefixBytes = this.getNumPrefixBytes();
        byte[] prefix = new byte[numPrefixBytes];
        int offset = 4 - numPrefixBytes;
        System.arraycopy(fourBytePrefix, offset, prefix, 0, numPrefixBytes);
        return prefix;
    }

    @Override
    public byte[] getPrefix(EK ek) {
        int partition = this.getPartition(ek);
        byte[] prefix = this.getPrefix(partition);
        return prefix;
    }

    @Override
    public byte[] getNextPrefix(int partition) {
        if (this.isLastPartition(partition)) {
            return null;
        }
        return this.getPrefix(partition + 1);
    }

    @Override
    public int parsePartitionFromBytes(byte[] bytes) {
        byte[] prefixBytes = ByteTool.copyOfRange((byte[])bytes, (int)0, (int)this.getNumPrefixBytes());
        return this.getPartition(prefixBytes);
    }

    @Override
    private int getPartition(byte[] bytes) {
        byte[] fourBytePrefix = ByteTool.padPrefix((byte[])bytes, (int)4);
        return IntegerByteTool.fromRawBytes((byte[])fourBytePrefix, (int)0);
    }

    static int getNumPrefixBytesStatic(int numPartitions) {
        if (numPartitions < 1) {
            throw new IllegalArgumentException("must have at least one partition");
        }
        if (numPartitions == 1) {
            return 0;
        }
        if (numPartitions <= 256) {
            return 1;
        }
        if (numPartitions <= 65536) {
            return 2;
        }
        throw new IllegalArgumentException("max partitions is 65536");
    }
}

