/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.key.entity.base;

import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.base.BaseEntityPartitioner;
import java.util.function.Function;

public abstract class BaseByteArrayEntityPartitioner<EK extends EntityKey<EK>>
extends BaseEntityPartitioner<EK> {
    private final Function<byte[], Long> hashMethod;

    public BaseByteArrayEntityPartitioner(Function<byte[], Long> hashMethod, int numPartitions) {
        super(numPartitions);
        this.hashMethod = hashMethod;
    }

    protected abstract byte[] makeByteArrayHashInput(EK var1);

    @Override
    public final int getPartition(EK ek) {
        byte[] hashInput = this.makeByteArrayHashInput(ek);
        long hash = this.hashMethod.apply(hashInput);
        long partition = hash % (long)this.getNumPartitions();
        return (int)partition;
    }
}

