/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.key.entity;

import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.EntityPrimaryKeyTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Range;
import java.util.List;

public interface EntityPartitioner<EK extends EntityKey<EK>> {
    public int getNumPartitions();

    public List<Integer> getAllPartitions();

    public boolean isLastPartition(int var1);

    public int getNumPrefixBytes();

    public List<byte[]> getAllPrefixes();

    public byte[][] getAllPrefixesArray();

    public byte[] getPrefix(int var1);

    public byte[] getPrefix(EK var1);

    public byte[] getNextPrefix(int var1);

    public int getPartition(EK var1);

    public int parsePartitionFromBytes(byte[] var1);

    default public Scanner<Integer> scanAllPartitions() {
        return Scanner.of(this.getAllPartitions());
    }

    default public Scanner<byte[]> scanAllPrefixes() {
        return Scanner.of(this.getAllPrefixes());
    }

    default public <PK extends EntityPrimaryKey<EK, PK>> Scanner<Integer> scanPartitions(Range<PK> range) {
        if (EntityPrimaryKeyTool.isSingleEntity(range)) {
            return Scanner.of((Object)this.getPartition(((EntityPrimaryKey)range.getStart()).getEntityKey()));
        }
        return this.scanAllPartitions();
    }

    default public <PK extends EntityPrimaryKey<EK, PK>> Scanner<byte[]> scanPrefixes(Range<PK> range) {
        return this.scanPartitions(range).map(this::getPrefix);
    }
}

