/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.positive;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.positive.VarIntFieldKey;
import io.datarouter.util.bytes.VarIntTool;
import io.datarouter.util.string.StringTool;

public class VarIntField
extends BasePrimitiveField<Integer, VarIntFieldKey> {
    public VarIntField(VarIntFieldKey key, Integer value) {
        super(key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Integer)this.value).toString();
    }

    @Override
    public Integer parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return VarIntField.assertInRange(str == null ? null : Integer.valueOf(str));
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : VarIntTool.encode((long)((Integer)this.value).intValue());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        long value = VarIntTool.decodeLong((byte[])bytes, (int)offset);
        return VarIntTool.length((long)value);
    }

    @Override
    public Integer fromBytesButDoNotSet(byte[] bytes, int offset) {
        return VarIntTool.decodeInt((byte[])bytes, (int)offset);
    }

    public static Integer assertInRange(Integer value) {
        if (value == null) {
            return value;
        }
        if (value >= 0) {
            return value;
        }
        throw new IllegalArgumentException("VarIntField must be null or positive integer");
    }
}

