/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.positive;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.number.RandomTool;
import io.datarouter.util.string.StringTool;
import java.util.Random;

public class UInt63Field
extends BasePrimitiveField<Long, UInt63FieldKey> {
    private static final Random random = new Random();

    public UInt63Field(String prefix, UInt63FieldKey key, Long value) {
        super(prefix, key, value);
    }

    public UInt63Field(UInt63FieldKey key, Long value) {
        this((String)null, key, value);
    }

    public static long nextPositiveRandom() {
        return RandomTool.nextPositiveLong((Random)random);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Long)this.value).toString();
    }

    @Override
    public Long parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : LongByteTool.getUInt63Bytes((long)((Long)this.value));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 8;
    }

    @Override
    public Long fromBytesButDoNotSet(byte[] bytes, int offset) {
        return LongByteTool.fromUInt63Bytes((byte[])bytes, (int)offset);
    }
}

