/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.positive;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.string.StringTool;

public class UInt31Field
extends BasePrimitiveField<Integer, UInt31FieldKey> {
    public UInt31Field(UInt31FieldKey key, Integer value) {
        this((String)null, key, value);
    }

    public UInt31Field(String prefix, UInt31FieldKey key, Integer value) {
        super(prefix, key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Integer)this.value).toString();
    }

    @Override
    public Integer parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return Integer.valueOf(str);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : IntegerByteTool.getUInt31Bytes((int)((Integer)this.value));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 4;
    }

    @Override
    public Integer fromBytesButDoNotSet(byte[] bytes, int offset) {
        return IntegerByteTool.fromUInt31Bytes((byte[])bytes, (int)offset);
    }
}

