/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.enums;

import io.datarouter.model.field.BaseField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.enums.IntegerEnumField;
import io.datarouter.model.field.imp.enums.IntegerEnumFieldKey;
import io.datarouter.model.field.imp.enums.VarIntEnumFieldKey;
import io.datarouter.util.bytes.VarIntTool;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.IntegerEnum;

public class VarIntEnumField<E extends IntegerEnum<E>>
extends BaseField<E> {
    private final VarIntEnumFieldKey<E> key;

    public VarIntEnumField(VarIntEnumFieldKey<E> key, E value) {
        super(null, value);
        this.key = key;
        this.value = value;
    }

    @Override
    public VarIntEnumFieldKey<E> getKey() {
        return this.key;
    }

    @Override
    public int compareTo(Field<E> other) {
        return DatarouterEnumTool.compareIntegerEnums((IntegerEnum)((IntegerEnum)this.value), (IntegerEnum)((IntegerEnum)other.getValue()));
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((IntegerEnum)this.value).getPersistentInteger().toString();
    }

    @Override
    public E parseStringEncodedValueButDoNotSet(String string) {
        if (string == null) {
            return null;
        }
        return (E)IntegerEnum.fromPersistentIntegerSafe(this.key.getSampleValue(), (Integer)Integer.valueOf(string));
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : VarIntTool.encode((long)((IntegerEnum)this.value).getPersistentInteger().intValue());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        long value = VarIntTool.decodeLong((byte[])bytes, (int)offset);
        return VarIntTool.length((long)value);
    }

    @Override
    public E fromBytesButDoNotSet(byte[] bytes, int offset) {
        int intValue = VarIntTool.decodeInt((byte[])bytes, (int)offset);
        return (E)IntegerEnum.fromPersistentIntegerSafe(this.key.getSampleValue(), (Integer)intValue);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "null" : ((IntegerEnum)this.value).getPersistentInteger().toString();
    }

    public static <E extends IntegerEnum<E>> IntegerEnumField<E> toIntegerEnumField(VarIntEnumField<E> field) {
        IntegerEnumFieldKey<IntegerEnum> integerEnumFieldKey = new IntegerEnumFieldKey<IntegerEnum>(field.key.getName(), field.key.getColumnName(), field.key.isNullable(), (Class<IntegerEnum>)field.key.getEnumClass(), field.key.getAutoGeneratedType(), (IntegerEnum)field.key.getDefaultValue(), (IntegerEnum)field.key.getSampleValue(), field.key.getAttributes());
        IntegerEnumField<IntegerEnum> integerEnumField = new IntegerEnumField<IntegerEnum>(integerEnumFieldKey, (IntegerEnum)field.getValue());
        integerEnumField.setPrefix(field.getPrefix());
        return integerEnumField;
    }
}

