/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.enums;

import io.datarouter.model.field.BaseField;
import io.datarouter.model.field.BaseFieldKey;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.encoding.FieldGeneratorType;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.enums.StringEnumFieldKey;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.StringEnum;

public class StringEnumField<E extends StringEnum<E>>
extends BaseField<E> {
    private final StringEnumFieldKey<E> key;
    private final StringField stringField;

    public StringEnumField(StringEnumFieldKey<E> key, E value) {
        this(key, value, null);
    }

    public StringEnumField(StringEnumFieldKey<E> key, E value, String prefix) {
        super(prefix, value);
        this.key = key;
        this.stringField = StringEnumField.toStringField(this);
    }

    @Override
    public StringEnumFieldKey<E> getKey() {
        return this.key;
    }

    @Override
    public int compareTo(Field<E> other) {
        return DatarouterEnumTool.compareStringEnums((StringEnum)((StringEnum)this.value), (StringEnum)((StringEnum)other.getValue()));
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((StringEnum)this.value).getPersistentString();
    }

    @Override
    public E parseStringEncodedValueButDoNotSet(String string) {
        return (E)StringEnum.fromPersistentStringSafe(this.getSampleValue(), (String)string);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : StringByteTool.getUtf8Bytes((String)((StringEnum)this.value).getPersistentString());
    }

    @Override
    public byte[] getBytesWithSeparator() {
        return this.stringField.getBytesWithSeparator();
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return this.stringField.numBytesWithSeparator(bytes, offset);
    }

    @Override
    public E fromBytesButDoNotSet(byte[] bytes, int offset) {
        String stringValue = this.stringField.fromBytesButDoNotSet(bytes, offset);
        return (E)StringEnum.fromPersistentStringSafe(this.getSampleValue(), (String)stringValue);
    }

    @Override
    public E fromBytesWithSeparatorButDoNotSet(byte[] bytes, int offset) {
        String stringValue = this.stringField.fromBytesWithSeparatorButDoNotSet(bytes, offset);
        return (E)StringEnum.fromPersistentStringSafe(this.getSampleValue(), (String)stringValue);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "null" : ((StringEnum)this.value).getPersistentString();
    }

    public E getSampleValue() {
        return this.key.getSampleValue();
    }

    public static StringField toStringField(StringEnumField<?> stringEnumField) {
        if (stringEnumField == null) {
            return null;
        }
        String value = null;
        if (stringEnumField.getValue() != null) {
            value = ((StringEnum)stringEnumField.getValue()).getPersistentString();
        }
        String defaultValue = null;
        if (((BaseFieldKey)stringEnumField.getKey()).getDefaultValue() != null) {
            defaultValue = ((StringEnum)((BaseFieldKey)stringEnumField.getKey()).getDefaultValue()).getPersistentString();
        }
        StringFieldKey key = new StringFieldKey(stringEnumField.key.getName(), stringEnumField.key.getColumnName(), stringEnumField.key.isNullable(), FieldGeneratorType.NONE, defaultValue, stringEnumField.key.getSize(), stringEnumField.key.getAttributes());
        return new StringField(stringEnumField.getPrefix(), key, value);
    }
}

