/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.enums;

import io.datarouter.model.field.BaseField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.enums.IntegerEnumFieldKey;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.IntegerEnum;

public class IntegerEnumField<E extends IntegerEnum<E>>
extends BaseField<E> {
    private final IntegerEnumFieldKey<E> key;

    public IntegerEnumField(IntegerEnumFieldKey<E> key, E value) {
        super(null, value);
        this.key = key;
    }

    @Override
    public IntegerEnumFieldKey<E> getKey() {
        return this.key;
    }

    public E getSampleValue() {
        return this.key.getSampleValue();
    }

    @Override
    public int compareTo(Field<E> other) {
        return DatarouterEnumTool.compareIntegerEnums((IntegerEnum)((IntegerEnum)this.value), (IntegerEnum)((IntegerEnum)other.getValue()));
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((IntegerEnum)this.value).getPersistentInteger().toString();
    }

    @Override
    public E parseStringEncodedValueButDoNotSet(String str) {
        if (str == null) {
            return null;
        }
        return (E)IntegerEnum.fromPersistentIntegerSafe(this.getSampleValue(), (Integer)Integer.valueOf(str));
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : IntegerByteTool.getComparableBytes((int)((IntegerEnum)this.value).getPersistentInteger());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 4;
    }

    @Override
    public E fromBytesButDoNotSet(byte[] bytes, int offset) {
        return (E)IntegerEnum.fromPersistentIntegerSafe(this.getSampleValue(), (Integer)IntegerByteTool.fromComparableBytes((byte[])bytes, (int)offset));
    }

    @Override
    public String getValueString() {
        return this.value == null ? "null" : ((IntegerEnum)this.value).getPersistentInteger().toString();
    }
}

