/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.custom;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.custom.LongDateFieldKey;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.string.StringTool;
import java.util.Date;

public class LongDateField
extends BasePrimitiveField<Date, LongDateFieldKey> {
    public LongDateField(LongDateFieldKey key, Date value) {
        super(key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return String.valueOf(((Date)this.value).getTime());
    }

    @Override
    public Date parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return new Date(Long.valueOf(str));
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : LongByteTool.getUInt63Bytes((long)((Date)this.value).getTime());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 8;
    }

    @Override
    public Date fromBytesButDoNotSet(byte[] bytes, int offset) {
        return new Date(LongByteTool.fromUInt63Bytes((byte[])bytes, (int)offset));
    }
}

