/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.custom;

import io.datarouter.model.field.FieldKeyAttribute;
import io.datarouter.model.field.FieldKeyAttributeKey;
import io.datarouter.model.field.PrimitiveFieldKey;
import io.datarouter.model.field.encoding.FieldGeneratorType;
import io.datarouter.model.field.imp.custom.LocalDateTimeField;
import java.time.LocalDateTime;
import java.util.Map;

public class LocalDateTimeFieldKey
extends PrimitiveFieldKey<LocalDateTime, LocalDateTimeFieldKey> {
    private final int numFractionalSeconds;

    public LocalDateTimeFieldKey(String name) {
        super(name, LocalDateTime.class);
        this.numFractionalSeconds = 6;
    }

    private LocalDateTimeFieldKey(String name, String columnName, boolean nullable, FieldGeneratorType fieldGeneratorType, LocalDateTime defaultValue, int numFractionalSeconds, Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> attributes) {
        super(name, columnName, nullable, LocalDateTime.class, fieldGeneratorType, defaultValue, attributes);
        this.numFractionalSeconds = numFractionalSeconds;
    }

    public int getNumFractionalSeconds() {
        return this.numFractionalSeconds;
    }

    public LocalDateTimeFieldKey withColumnName(String columnNameOverride) {
        return new LocalDateTimeFieldKey(this.name, columnNameOverride, this.nullable, this.fieldGeneratorType, (LocalDateTime)this.defaultValue, this.numFractionalSeconds, this.attributes);
    }

    public LocalDateTimeFieldKey overrideNumFractionalSeconds(int numFractionalSeconds) {
        if (numFractionalSeconds < 0 || numFractionalSeconds > 9) {
            throw new RuntimeException("numFractionalSeconds cannot be less than 0 or greater than 9");
        }
        return new LocalDateTimeFieldKey(this.name, this.columnName, this.nullable, this.fieldGeneratorType, (LocalDateTime)this.defaultValue, numFractionalSeconds, this.attributes);
    }

    public LocalDateTimeField createValueField(LocalDateTime value) {
        return new LocalDateTimeField(this, value);
    }
}

