/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.custom;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.custom.LocalDateTimeFieldKey;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.bytes.ShortByteTool;
import io.datarouter.util.string.StringTool;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeField
extends BasePrimitiveField<LocalDateTime, LocalDateTimeFieldKey> {
    private static final int NUM_BYTES = 15;
    private static final int TOTAL_NUM_FRACTIONAL_SECONDS = 9;
    public static final String pattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");

    public LocalDateTimeField(LocalDateTimeFieldKey key, LocalDateTime value) {
        this((String)null, key, value);
    }

    public LocalDateTimeField(String prefix, LocalDateTimeFieldKey key, LocalDateTime value) {
        super(prefix, key, value);
        this.setValue(this.getTruncatedLocalDateTime(value));
    }

    public LocalDateTime getTruncatedLocalDateTime(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        int divideBy = (int)Math.pow(10.0, 9 - this.getNumFractionalSeconds());
        if (divideBy < 1) {
            throw new RuntimeException("numFractionalSeconds is greater or equal to 9");
        }
        int numNanoSeconds = value.getNano() / divideBy * divideBy;
        return value.withNano(numNanoSeconds);
    }

    public int getNumFractionalSeconds() {
        return ((LocalDateTimeFieldKey)this.getKey()).getNumFractionalSeconds();
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((LocalDateTime)this.value).format(formatter);
    }

    @Override
    public LocalDateTime parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isNullOrEmpty((String)str)) {
            return null;
        }
        return LocalDateTime.parse(str, formatter);
    }

    @Override
    public byte[] getBytes() {
        if (this.value == null) {
            return null;
        }
        byte[] bytes = new byte[15];
        int offset = 0;
        offset += IntegerByteTool.toComparableBytes((int)((LocalDateTime)this.value).getYear(), (byte[])bytes, (int)offset);
        offset += ShortByteTool.toComparableBytes((short)((short)((LocalDateTime)this.value).getMonthValue()), (byte[])bytes, (int)offset);
        offset += ShortByteTool.toComparableBytes((short)((short)((LocalDateTime)this.value).getDayOfMonth()), (byte[])bytes, (int)offset);
        bytes[offset++] = (byte)((LocalDateTime)this.value).getHour();
        bytes[offset++] = (byte)((LocalDateTime)this.value).getMinute();
        bytes[offset++] = (byte)((LocalDateTime)this.value).getSecond();
        offset += IntegerByteTool.toComparableBytes((int)((LocalDateTime)this.value).getNano(), (byte[])bytes, (int)offset);
        return bytes;
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 15;
    }

    @Override
    public LocalDateTime fromBytesButDoNotSet(byte[] bytes, int offset) {
        int year = IntegerByteTool.fromComparableBytes((byte[])bytes, (int)offset);
        short month = ShortByteTool.fromComparableBytes((byte[])bytes, (int)(offset += 4));
        short day = ShortByteTool.fromComparableBytes((byte[])bytes, (int)(offset += 2));
        offset += 2;
        byte hour = bytes[offset++];
        byte minute = bytes[offset++];
        byte second = bytes[offset++];
        int nano = IntegerByteTool.fromComparableBytes((byte[])bytes, (int)offset);
        return LocalDateTime.of(year, month, (int)day, (int)hour, (int)minute, (int)second, nano);
    }
}

