/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.comparable;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.string.StringTool;

public class LongField
extends BasePrimitiveField<Long, LongFieldKey> {
    public LongField(LongFieldKey key, Long value) {
        this((String)null, key, value);
    }

    public LongField(String prefix, LongFieldKey key, Long value) {
        super(prefix, key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Long)this.value).toString();
    }

    @Override
    public Long parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : LongByteTool.getComparableBytes((long)((Long)this.value));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 8;
    }

    @Override
    public Long fromBytesButDoNotSet(byte[] bytes, int offset) {
        return LongByteTool.fromComparableBytes((byte[])bytes, (int)offset);
    }
}

