/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.comparable;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.comparable.InstantFieldKey;
import io.datarouter.util.array.LongArray;
import io.datarouter.util.bytes.LongByteTool;
import java.time.Instant;
import java.util.List;

public class InstantField
extends BasePrimitiveField<Instant, InstantFieldKey> {
    public InstantField(InstantFieldKey key, Instant value) {
        super(key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Instant)this.value).toString();
    }

    @Override
    public Instant parseStringEncodedValueButDoNotSet(String value) {
        return Instant.parse(value);
    }

    @Override
    public byte[] getBytes() {
        if (this.value == null) {
            return null;
        }
        LongArray longArray = new LongArray(2);
        longArray.add(((Instant)this.value).getEpochSecond());
        longArray.add((long)((Instant)this.value).getNano());
        return LongByteTool.getUInt63ByteArray((List)longArray);
    }

    @Override
    public Instant fromBytesButDoNotSet(byte[] bytes, int byteOffset) {
        long[] secondsAndNanos = LongByteTool.fromUInt63ByteArray((byte[])bytes, (int)byteOffset, (int)16);
        return Instant.ofEpochSecond(secondsAndNanos[0], secondsAndNanos[1]);
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int byteOffset) {
        return 16;
    }

    public int getNumFractionalSeconds() {
        return ((InstantFieldKey)this.getKey()).getNumFractionalSeconds();
    }
}

