/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.comparable;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.comparable.FloatFieldKey;
import io.datarouter.util.bytes.FloatByteTool;
import io.datarouter.util.string.StringTool;

public class FloatField
extends BasePrimitiveField<Float, FloatFieldKey> {
    public FloatField(FloatFieldKey key, Float value) {
        super(key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Float)this.value).toString();
    }

    @Override
    public Float parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return Float.valueOf(str);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : FloatByteTool.toComparableBytes((float)((Float)this.value).floatValue());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 4;
    }

    @Override
    public Float fromBytesButDoNotSet(byte[] bytes, int offset) {
        return Float.valueOf(FloatByteTool.fromComparableBytes((byte[])bytes, (int)offset));
    }
}

