/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.comparable;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.comparable.DoubleFieldKey;
import io.datarouter.util.bytes.DoubleByteTool;
import io.datarouter.util.string.StringTool;

public class DoubleField
extends BasePrimitiveField<Double, DoubleFieldKey> {
    public DoubleField(DoubleFieldKey key, Double value) {
        super(key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((Double)this.value).toString();
    }

    @Override
    public Double parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        return Double.valueOf(str);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : DoubleByteTool.toComparableBytes((double)((Double)this.value));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 8;
    }

    @Override
    public Double fromBytesButDoNotSet(byte[] bytes, int offset) {
        return DoubleByteTool.fromComparableBytes((byte[])bytes, (int)offset);
    }
}

