/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.array;

import io.datarouter.model.field.BaseListField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.array.UInt7ArrayFieldKey;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.collection.ListTool;
import io.datarouter.util.serialization.GsonTool;
import java.util.List;

public class UInt7ArrayField
extends BaseListField<Byte, List<Byte>, UInt7ArrayFieldKey> {
    public UInt7ArrayField(UInt7ArrayFieldKey key, List<Byte> value) {
        super(key, value);
    }

    @Override
    public List<Byte> parseStringEncodedValueButDoNotSet(String value) {
        return (List)GsonTool.GSON.fromJson(value, ((UInt7ArrayFieldKey)this.getKey()).getValueType());
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : ByteTool.getUInt7Bytes((List)((List)this.value));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int byteOffset) {
        return IntegerByteTool.fromUInt31Bytes((byte[])bytes, (int)byteOffset);
    }

    @Override
    public List<Byte> fromBytesWithSeparatorButDoNotSet(byte[] bytes, int byteOffset) {
        int numBytes = this.numBytesWithSeparator(bytes, byteOffset) - 4;
        return ByteTool.getArrayList((byte[])ByteTool.fromUInt7ByteArray((byte[])bytes, (int)(byteOffset + 4), (int)numBytes));
    }

    @Override
    public List<Byte> fromBytesButDoNotSet(byte[] bytes, int byteOffset) {
        int numBytes = ArrayTool.length((byte[])bytes) - byteOffset;
        return ByteTool.getArrayList((byte[])ByteTool.fromUInt7ByteArray((byte[])bytes, (int)byteOffset, (int)numBytes));
    }

    @Override
    public int compareTo(Field<List<Byte>> other) {
        return ListTool.compare((List)((List)this.value), other.getValue());
    }
}

