/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.array;

import io.datarouter.model.field.BaseListField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.array.UInt63ArrayFieldKey;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.array.LongArray;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.collection.ListTool;
import io.datarouter.util.serialization.GsonTool;
import java.util.List;

public class UInt63ArrayField
extends BaseListField<Long, List<Long>, UInt63ArrayFieldKey> {
    public UInt63ArrayField(UInt63ArrayFieldKey key, List<Long> value) {
        super(key, value);
    }

    @Override
    public int compareTo(Field<List<Long>> other) {
        return ListTool.compare((List)((List)this.value), other.getValue());
    }

    @Override
    public List<Long> parseStringEncodedValueButDoNotSet(String value) {
        return (List)GsonTool.GSON.fromJson(value, ((UInt63ArrayFieldKey)this.getKey()).getValueType());
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : LongByteTool.getUInt63ByteArray((List)((List)this.value));
    }

    @Override
    public List<Long> fromBytesButDoNotSet(byte[] bytes, int byteOffset) {
        int numBytes = ArrayTool.length((byte[])bytes) - byteOffset;
        return new LongArray(LongByteTool.fromUInt63ByteArray((byte[])bytes, (int)byteOffset, (int)numBytes));
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int byteOffset) {
        return bytes == null ? 0 : IntegerByteTool.fromUInt31Bytes((byte[])bytes, (int)byteOffset) + 4;
    }

    @Override
    public byte[] getBytesWithSeparator() {
        if (this.value == null) {
            return IntegerByteTool.getUInt31Bytes((int)0);
        }
        byte[] dataBytes = LongByteTool.getUInt63ByteArray((List)((List)this.value));
        byte[] allBytes = new byte[4 + dataBytes.length];
        System.arraycopy(IntegerByteTool.getUInt31Bytes((int)dataBytes.length), 0, allBytes, 0, 4);
        System.arraycopy(dataBytes, 0, allBytes, 4, dataBytes.length);
        return allBytes;
    }

    @Override
    public List<Long> fromBytesWithSeparatorButDoNotSet(byte[] bytes, int byteOffset) {
        int numBytes = this.numBytesWithSeparator(bytes, byteOffset) - 4;
        return new LongArray(LongByteTool.fromUInt63ByteArray((byte[])bytes, (int)(byteOffset + 4), (int)numBytes));
    }
}

