/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.array;

import io.datarouter.model.field.imp.array.DelimitedStringArrayFieldKey;
import io.datarouter.model.field.imp.array.KeyedListField;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.bytes.StringByteTool;
import java.util.ArrayList;
import java.util.List;

public class DelimitedStringArrayField
extends KeyedListField<String, List<String>, DelimitedStringArrayFieldKey> {
    public DelimitedStringArrayField(DelimitedStringArrayFieldKey key, List<String> values) {
        super(key, values);
    }

    public String getSeparator() {
        return ((DelimitedStringArrayFieldKey)this.key).separator;
    }

    @Override
    public String getStringEncodedValue() {
        return DelimitedStringArrayField.encode((List)this.value, ((DelimitedStringArrayFieldKey)this.key).separator);
    }

    @Override
    public List<String> parseStringEncodedValueButDoNotSet(String string) {
        return DelimitedStringArrayField.decode(string, ((DelimitedStringArrayFieldKey)this.key).separator);
    }

    @Override
    public byte[] getBytes() {
        String encodedString = DelimitedStringArrayField.encode((List)this.value, ((DelimitedStringArrayFieldKey)this.key).separator);
        if (encodedString == null) {
            return null;
        }
        return StringByteTool.getUtf8Bytes((String)encodedString);
    }

    @Override
    public List<String> fromBytesButDoNotSet(byte[] bytes, int byteOffset) {
        if (bytes == null) {
            return null;
        }
        String encodedString = StringByteTool.fromUtf8Bytes((byte[])bytes);
        return DelimitedStringArrayField.decode(encodedString, ((DelimitedStringArrayFieldKey)this.key).separator);
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int byteOffset) {
        throw new UnsupportedOperationException();
    }

    public static String encode(List<String> inputs, String separator) {
        if (inputs == null) {
            return null;
        }
        if (inputs.isEmpty()) {
            return "";
        }
        for (String input : inputs) {
            if (input == null) {
                throw new IllegalArgumentException("nulls not supported");
            }
            if (!input.contains(separator)) continue;
            throw new IllegalArgumentException("strings cannot contain separator");
        }
        return String.join((CharSequence)separator, inputs);
    }

    public static List<String> decode(String input, String separator) {
        if (input == null) {
            return null;
        }
        if ("".equals(input)) {
            return new ArrayList<String>();
        }
        return Scanner.of((Object[])input.split(separator)).list();
    }
}

