/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp.array;

import io.datarouter.model.field.BaseField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.array.ByteArrayFieldKey;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class ByteArrayField
extends BaseField<byte[]> {
    private ByteArrayFieldKey key;

    public ByteArrayField(ByteArrayFieldKey key, byte[] value) {
        super(null, value);
        this.key = key;
    }

    public ByteArrayFieldKey getKey() {
        return this.key;
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString((byte[])this.value);
    }

    @Override
    public byte[] parseStringEncodedValueButDoNotSet(String stringValue) {
        return Base64.getDecoder().decode(stringValue);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : ByteTool.flipToAndFromComparableByteArray((byte[])((byte[])this.value));
    }

    @Override
    public byte[] getBytesWithSeparator() {
        if (this.value == null) {
            return null;
        }
        byte[] dataBytes = ByteTool.flipToAndFromComparableByteArray((byte[])((byte[])this.value));
        byte[] allBytes = new byte[4 + ArrayTool.length((byte[])dataBytes)];
        System.arraycopy(IntegerByteTool.getUInt31Bytes((int)0), 0, allBytes, 4, 4);
        System.arraycopy(dataBytes, 0, allBytes, 4, ArrayTool.length((byte[])dataBytes));
        return allBytes;
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return IntegerByteTool.fromUInt31Bytes((byte[])bytes, (int)offset);
    }

    @Override
    public byte[] fromBytesWithSeparatorButDoNotSet(byte[] bytes, int offset) {
        int numBytes = this.numBytesWithSeparator(bytes, offset) - 4;
        return ByteTool.flipToAndFromComparableByteArray((byte[])bytes, (int)(offset + 4), (int)numBytes);
    }

    @Override
    public byte[] fromBytesButDoNotSet(byte[] bytes, int byteOffset) {
        int length = bytes.length - byteOffset;
        return ByteTool.flipToAndFromComparableByteArray((byte[])bytes, (int)byteOffset, (int)length);
    }

    @Override
    public String getValueString() {
        return this.value == null ? "null" : Hex.encodeHexString((byte[])((byte[])this.value));
    }

    @Override
    public int getValueHashCode() {
        return Arrays.hashCode((byte[])this.value);
    }

    @Override
    public int compareTo(Field<byte[]> other) {
        return Arrays.compareUnsigned((byte[])this.value, other.getValue());
    }
}

