/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp;

import io.datarouter.model.field.BaseFieldKey;
import io.datarouter.model.field.FieldKeyAttribute;
import io.datarouter.model.field.FieldKeyAttributeKey;
import io.datarouter.model.field.encoding.FieldGeneratorType;
import io.datarouter.model.field.imp.StringField;
import java.util.Map;

public class StringFieldKey
extends BaseFieldKey<String, StringFieldKey> {
    private static final int DEFAULT_MAX_SIZE = 255;
    private final int size;

    public StringFieldKey(String name) {
        super(name, String.class);
        this.size = 255;
    }

    public StringFieldKey(String name, String columnName, boolean nullable, FieldGeneratorType fieldGeneratorType, String defaultValue, int size, Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> attributes) {
        super(name, columnName, nullable, String.class, fieldGeneratorType, defaultValue, attributes);
        this.size = size;
    }

    public StringFieldKey withSize(int sizeOverride) {
        return new StringFieldKey(this.name, this.columnName, this.nullable, this.fieldGeneratorType, (String)this.defaultValue, sizeOverride, this.attributes);
    }

    public StringFieldKey withColumnName(String columnNameOverride) {
        return new StringFieldKey(this.name, columnNameOverride, this.nullable, this.fieldGeneratorType, (String)this.defaultValue, this.size, this.attributes);
    }

    public StringFieldKey notNullable() {
        return new StringFieldKey(this.name, this.columnName, false, this.fieldGeneratorType, (String)this.defaultValue, this.size, this.attributes);
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public StringField createValueField(String value) {
        return new StringField(this, value);
    }
}

