/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp;

import io.datarouter.model.field.BaseField;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldKey;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.util.ComparableTool;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.StringByteTool;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class StringField
extends BaseField<String> {
    public static final byte SEPARATOR = 0;
    private final StringFieldKey key;

    public StringField(StringFieldKey key, String value) {
        super(null, value);
        this.key = key;
    }

    public StringField(String prefix, StringFieldKey key, String value) {
        super(prefix, value);
        this.key = key;
    }

    @Override
    public FieldKey<String> getKey() {
        return this.key;
    }

    @Override
    public int compareTo(Field<String> other) {
        if (other == null) {
            return -1;
        }
        return ComparableTool.nullFirstCompareTo((Comparable)((Object)((String)this.getValue())), (Comparable)((Object)other.getValue()));
    }

    @Override
    public String getStringEncodedValue() {
        return (String)this.value;
    }

    @Override
    public String parseStringEncodedValueButDoNotSet(String string) {
        return string;
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : StringByteTool.getUtf8Bytes((String)((String)this.value));
    }

    @Override
    public byte[] getBytesWithSeparator() {
        byte[] dataBytes = this.getBytes();
        if (ArrayTool.containsUnsorted((byte[])dataBytes, (byte)0)) {
            throw new IllegalArgumentException("String cannot contain separator byteVal=0, stringBytes=" + Arrays.toString(dataBytes) + ", string=" + (String)this.value + ", key=" + this.key);
        }
        if (ArrayTool.isEmpty((byte[])dataBytes)) {
            return new byte[1];
        }
        byte[] allBytes = new byte[dataBytes.length + 1];
        System.arraycopy(dataBytes, 0, allBytes, 0, dataBytes.length);
        allBytes[allBytes.length - 1] = 0;
        return allBytes;
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        int i = offset;
        while (i < bytes.length) {
            if (bytes[i] == 0) {
                return i - offset + 1;
            }
            ++i;
        }
        int numBytes = bytes.length - offset;
        return numBytes >= 0 ? numBytes : 0;
    }

    @Override
    public String fromBytesButDoNotSet(byte[] bytes, int offset) {
        int length = bytes.length - offset;
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    @Override
    public String fromBytesWithSeparatorButDoNotSet(byte[] bytes, int offset) {
        int lengthWithPossibleSeparator = this.numBytesWithSeparator(bytes, offset);
        if (lengthWithPossibleSeparator == 0) {
            return "";
        }
        int lastByteIndex = offset + lengthWithPossibleSeparator - 1;
        boolean lastByteIsSeparator = bytes[lastByteIndex] == 0;
        int lengthWithoutSeparator = lastByteIsSeparator ? lengthWithPossibleSeparator - 1 : lengthWithPossibleSeparator;
        return new String(bytes, offset, lengthWithoutSeparator, StandardCharsets.UTF_8);
    }

    public int getSize() {
        return this.key.getSize();
    }
}

