/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.LocalDateFieldKey;
import io.datarouter.util.bytes.ShortByteTool;
import io.datarouter.util.string.StringTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateField
extends BasePrimitiveField<LocalDate, LocalDateFieldKey> {
    private static final int NUM_BYTES = 4;

    public LocalDateField(LocalDateFieldKey key, LocalDate value) {
        this((String)null, key, value);
    }

    public LocalDateField(String prefix, LocalDateFieldKey key, LocalDate value) {
        super(prefix, key, value);
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return ((LocalDate)this.value).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    public LocalDate parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isNullOrEmpty((String)str)) {
            return null;
        }
        return LocalDate.parse(str, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    public byte[] getBytes() {
        if (this.value == null) {
            return null;
        }
        byte[] bytes = new byte[4];
        ShortByteTool.toComparableBytes((short)((short)((LocalDate)this.value).getYear()), (byte[])bytes, (int)0);
        bytes[2] = (byte)((LocalDate)this.value).getMonthValue();
        bytes[3] = (byte)((LocalDate)this.value).getDayOfMonth();
        return bytes;
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 4;
    }

    @Override
    public LocalDate fromBytesButDoNotSet(byte[] bytes, int offset) {
        short year = ShortByteTool.fromComparableBytes((byte[])bytes, (int)offset);
        byte month = bytes[offset + 2];
        byte day = bytes[offset + 3];
        return LocalDate.of((int)year, month, (int)day);
    }
}

