/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.imp;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.util.DateTool;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.string.StringTool;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateField
extends BasePrimitiveField<Date, DateFieldKey> {
    @Deprecated
    public DateField(DateFieldKey key, Date value) {
        this((String)null, key, value);
    }

    @Deprecated
    public DateField(String prefix, DateFieldKey key, Date value) {
        super(prefix, key, value);
    }

    public int getNumDecimalSeconds() {
        return ((DateFieldKey)this.getKey()).getNumDecimalSeconds();
    }

    @Override
    public String getStringEncodedValue() {
        if (this.value == null) {
            return null;
        }
        return DateTool.getInternetDate((Date)((Date)this.value), (int)this.getNumDecimalSeconds());
    }

    @Override
    public Date parseStringEncodedValueButDoNotSet(String str) {
        if (StringTool.isEmpty((String)str) || "null".equals(str)) {
            return null;
        }
        Instant instant = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)str, Instant::from);
        long epochMilli = instant.toEpochMilli();
        long divider = (long)Math.pow(10.0, 3 - this.getNumDecimalSeconds());
        epochMilli = epochMilli / divider * divider;
        return new Date(epochMilli);
    }

    @Override
    public byte[] getBytes() {
        return this.value == null ? null : LongByteTool.getUInt63Bytes((long)((Date)this.value).getTime());
    }

    @Override
    public int numBytesWithSeparator(byte[] bytes, int offset) {
        return 8;
    }

    @Override
    public Date fromBytesButDoNotSet(byte[] bytes, int offset) {
        return new Date(LongByteTool.fromUInt63Bytes((byte[])bytes, (int)offset));
    }
}

