/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field.compare;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSet;
import io.datarouter.util.ComparableTool;
import io.datarouter.util.tuple.Range;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class FieldSetRangeFilter {
    public static <FS extends FieldSet<?>> boolean include(FieldSet<?> candidate, Range<? extends FS> range, String nodeName) {
        boolean matchesStart = true;
        if (range.hasStart()) {
            matchesStart = FieldSetRangeFilter.isCandidateAfterStartOfRange(candidate.getFields(), ((FieldSet)range.getStart()).getFields(), range.getStartInclusive(), nodeName);
        }
        boolean matchesEnd = true;
        if (range.hasEnd()) {
            matchesEnd = FieldSetRangeFilter.isCandidateBeforeEndOfRange(candidate.getFields(), ((FieldSet)range.getEnd()).getFields(), range.getEndInclusive());
        }
        return matchesStart && matchesEnd;
    }

    public static boolean isCandidateAfterStartOfRange(List<Field<?>> candidateFields, List<Field<?>> startOfRangeFields, boolean inclusive, String nodeName) {
        if (startOfRangeFields == null) {
            return true;
        }
        if (startOfRangeFields.size() != candidateFields.size()) {
            throw new IllegalArgumentException("inputs must have identical field count");
        }
        Iterator<Field<?>> candidateIterator = candidateFields.iterator();
        Iterator<Field<?>> startOfRangeIterator = startOfRangeFields.iterator();
        int counter = 0;
        while (startOfRangeIterator.hasNext()) {
            boolean lastField;
            ++counter;
            Field<?> candidate = candidateIterator.next();
            if (candidate.getValue() == null) {
                throw new IllegalArgumentException("currently don't support nulls in node=" + nodeName + " candidate=" + candidateFields);
            }
            Field<?> startOfRange = startOfRangeIterator.next();
            if (startOfRange.getValue() == null) {
                return inclusive;
            }
            int diff = ComparableTool.nullFirstCompareTo(candidate, startOfRange);
            if (diff > 0) {
                return true;
            }
            if (diff < 0) {
                return false;
            }
            boolean bl = lastField = counter == startOfRangeFields.size();
            if (!lastField) continue;
            return inclusive;
        }
        throw new IllegalStateException("shouldn't get here");
    }

    public static boolean isCandidateBeforeEndOfRange(List<Field<?>> candidateFields, List<Field<?>> endOfRangeFields, boolean inclusive) {
        if (endOfRangeFields == null) {
            return true;
        }
        if (endOfRangeFields.size() != candidateFields.size()) {
            throw new IllegalArgumentException("inputs must have identical field count");
        }
        Iterator<Field<?>> candidateIterator = candidateFields.iterator();
        Iterator<Field<?>> endOfRangeIterator = endOfRangeFields.iterator();
        int counter = 0;
        while (endOfRangeIterator.hasNext()) {
            boolean lastField;
            ++counter;
            Field<?> candidate = candidateIterator.next();
            Objects.requireNonNull(candidate.getValue(), "currently don't support nulls, candidate=" + candidateFields);
            Field<?> endOfRange = endOfRangeIterator.next();
            if (endOfRange.getValue() == null) {
                return inclusive;
            }
            int diff = ComparableTool.nullFirstCompareTo(candidate, endOfRange);
            if (diff < 0) {
                return true;
            }
            if (diff > 0) {
                return false;
            }
            boolean bl = lastField = counter == endOfRangeFields.size();
            if (!lastField) continue;
            return inclusive;
        }
        throw new IllegalStateException("shouldn't get here");
    }
}

