/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field;

import io.datarouter.model.field.Field;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.bytes.VarIntTool;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.string.StringTool;
import java.util.List;

public class FieldTool {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static int countNonNullLeadingFields(List<Field<?>> fields) {
        int num = 0;
        while (num < fields.size() && fields.get(num).getValue() != null) {
            ++num;
        }
        return num;
    }

    public static byte[] getPartitionerInput(List<Field<?>> fields) {
        int numTokens = FieldTool.countNonNullLeadingFields(fields);
        if (numTokens == 0) {
            throw new IllegalArgumentException("Partitioner needs at least one field");
        }
        byte[][] tokens = new byte[numTokens][];
        int i = 0;
        while (i < numTokens) {
            Field<?> field = fields.get(i);
            boolean finalField = i == numTokens - 1;
            tokens[i] = finalField ? field.getBytes() : field.getBytesWithSeparator();
            ++i;
        }
        return ByteTool.concatenate((byte[][])tokens);
    }

    public static byte[] getConcatenatedValueBytesUnterminated(List<Field<?>> fields) {
        int numTokens = FieldTool.countNonNullLeadingFields(fields);
        if (numTokens == 0) {
            return EMPTY_BYTES;
        }
        byte[][] tokens = new byte[numTokens][];
        int i = 0;
        while (i < numTokens) {
            Field<?> field = fields.get(i);
            boolean finalField = i == fields.size() - 1;
            tokens[i] = finalField ? field.getBytes() : field.getBytesWithSeparator();
            ++i;
        }
        return ByteTool.concatenate((byte[][])tokens);
    }

    public static byte[] getConcatenatedValueBytes(List<Field<?>> fields) {
        int numTokens = FieldTool.countNonNullLeadingFields(fields);
        if (numTokens == 0) {
            return EMPTY_BYTES;
        }
        byte[][] tokens = new byte[numTokens][];
        int i = 0;
        while (i < numTokens) {
            tokens[i] = fields.get(i).getBytesWithSeparator();
            ++i;
        }
        return ByteTool.concatenate((byte[][])tokens);
    }

    public static byte[] getSerializedKeyValues(List<Field<?>> fields, boolean includePrefix, boolean skipNullValues) {
        byte[][] tokens = new byte[4 * fields.size()][];
        int index = 0;
        for (Field<?> field : fields) {
            byte[] value = field.getBytes();
            if (value == null && skipNullValues) continue;
            byte[] key = includePrefix ? StringByteTool.getUtf8Bytes((String)field.getPrefixedName()) : field.getKey().getColumnNameBytes();
            tokens[index++] = VarIntTool.encode((long)key.length);
            tokens[index++] = key;
            tokens[index++] = VarIntTool.encode((long)value.length);
            tokens[index++] = value;
        }
        return ByteTool.concatenate((byte[][])tokens);
    }

    public static List<Field<?>> prependPrefixes(String prefixPrefix, List<Field<?>> fields) {
        fields.forEach(field -> {
            if (StringTool.isEmpty((String)field.getPrefix())) {
                field.setPrefix(prefixPrefix);
            } else {
                field.setPrefix(String.valueOf(prefixPrefix) + "." + field.getPrefix());
            }
        });
        return fields;
    }

    public static Object getNestedFieldSet(Object object, Field<?> field) {
        if (StringTool.isEmpty((String)field.getPrefix())) {
            return object;
        }
        String[] fieldNames = field.getPrefix().split("\\.");
        Object current = object;
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            current = ReflectionTool.get((String)fieldName, (Object)current);
            ++n2;
        }
        return current;
    }
}

