/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSet;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.ByteReader;
import io.datarouter.util.lang.ReflectionTool;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class FieldSetTool {
    public static <F extends FieldSet<F>> F clone(F fieldSet) {
        FieldSet copy = (FieldSet)ReflectionTool.create(fieldSet.getClass());
        fieldSet.getFields().forEach(field -> field.setUsingReflection(copy, field.getValue()));
        return (F)copy;
    }

    public static <F> F fieldSetFromBytes(Supplier<F> supplier, Map<String, Field<?>> fieldByPrefixedName, byte[] bytes) {
        F fieldSet = supplier.get();
        ByteReader reader = new ByteReader(bytes);
        while (reader.hasMore()) {
            String prefixedName = reader.varUtf8();
            byte[] valueBytes = reader.varBytes();
            Field<?> field = fieldByPrefixedName.get(prefixedName);
            if (field == null) continue;
            Object value = field.fromBytesButDoNotSet(valueBytes, 0);
            field.setUsingReflection(fieldSet, value);
        }
        return fieldSet;
    }

    public static <F extends FieldSet<?>> F fromConcatenatedValueBytes(Class<F> cls, List<Field<?>> fields, byte[] bytes) {
        FieldSet fieldSet = (FieldSet)ReflectionTool.create(cls);
        if (ArrayTool.isEmpty((byte[])bytes)) {
            return (F)fieldSet;
        }
        int byteOffset = 0;
        for (Field<?> field : fields) {
            Object value;
            if (byteOffset == bytes.length) break;
            int numBytesWithSeparator = field.numBytesWithSeparator(bytes, byteOffset);
            try {
                value = field.fromBytesWithSeparatorButDoNotSet(bytes, byteOffset);
            }
            catch (Exception e) {
                throw new RuntimeException("could not decode class=" + cls.getName() + " field=" + field + " offset=" + byteOffset + " bytes=" + Base64.getEncoder().encodeToString(bytes), e);
            }
            field.setUsingReflection(fieldSet, value);
            byteOffset += numBytesWithSeparator;
        }
        return (F)fieldSet;
    }
}

