/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldKey;
import io.datarouter.model.field.FieldSet;
import io.datarouter.model.field.compare.FieldSetComparator;
import io.datarouter.model.util.PercentFieldCodec;
import io.datarouter.scanner.Scanner;
import java.util.List;

public abstract class BaseFieldSet<F extends FieldSet<F>>
implements FieldSet<F> {
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        return FieldSetComparator.compareStatic(this, (FieldSet)that) == 0;
    }

    public int hashCode() {
        int result = 0;
        for (Field<?> field : this.getFields()) {
            result = 31 * result + field.getValueHashCode();
        }
        return result;
    }

    @Override
    public int compareTo(FieldSet<F> that) {
        return FieldSetComparator.compareStatic(this, that);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + PercentFieldCodec.encodeFields(this.getFields());
    }

    @Override
    public List<String> getFieldNames() {
        return Scanner.of(this.getFields()).map(Field::getKey).map(FieldKey::getName).list();
    }

    @Override
    public List<?> getFieldValues() {
        return Scanner.of(this.getFields()).map(Field::getValue).list();
    }

    @Override
    public Object getFieldValue(String fieldName) {
        return Scanner.of(this.getFields()).include(field -> field.getKey().getName().equals(fieldName)).findFirst().map(Field::getValue).orElse(null);
    }

    @Override
    public List<Field<?>> getFields(F fieldset) {
        return fieldset.getFields();
    }
}

