/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field;

import com.google.gson.reflect.TypeToken;
import io.datarouter.model.field.FieldKey;
import io.datarouter.model.field.FieldKeyAttribute;
import io.datarouter.model.field.FieldKeyAttributeKey;
import io.datarouter.model.field.encoding.FieldGeneratorType;
import io.datarouter.util.bytes.StringByteTool;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class BaseFieldKey<T, K extends BaseFieldKey<T, K>>
implements FieldKey<T> {
    protected final String name;
    protected final String columnName;
    protected final boolean nullable;
    protected final FieldGeneratorType fieldGeneratorType;
    protected final T defaultValue;
    protected final Type valueType;
    protected final Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> attributes;

    protected BaseFieldKey(String name, Class<T> valueType) {
        this(name, TypeToken.get(valueType));
    }

    protected BaseFieldKey(String name, TypeToken<T> valueType) {
        this(name, name, true, valueType, FieldGeneratorType.NONE, null, new HashMap());
    }

    protected BaseFieldKey(String name, String columnName, boolean nullable, Class<T> valueType, FieldGeneratorType fieldGeneratorType, T defaultValue, Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> attributes) {
        this(name, columnName, nullable, TypeToken.get(valueType), fieldGeneratorType, defaultValue, attributes);
    }

    protected BaseFieldKey(String name, String columnName, boolean nullable, TypeToken<T> valueType, FieldGeneratorType fieldGeneratorType, T defaultValue, Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> attributes) {
        this.name = name;
        this.columnName = columnName;
        this.nullable = nullable;
        this.attributes = attributes;
        this.valueType = valueType.getType();
        this.fieldGeneratorType = fieldGeneratorType;
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ":" + this.name + "]";
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public byte[] getColumnNameBytes() {
        return StringByteTool.getUtf8Bytes((String)this.columnName);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public FieldGeneratorType getAutoGeneratedType() {
        return this.fieldGeneratorType;
    }

    @Override
    public T generateRandomValue() {
        throw new UnsupportedOperationException();
    }

    public final <V> K with(FieldKeyAttribute<V> attribute) {
        this.attributes.put(attribute.getKey(), attribute);
        return (K)this;
    }

    @Override
    public final <U extends FieldKeyAttribute<U>> Optional<U> findAttribute(FieldKeyAttributeKey<U> key) {
        return Optional.ofNullable(this.attributes.get(key));
    }

    @Override
    public Map<FieldKeyAttributeKey<?>, FieldKeyAttribute<?>> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.columnName, this.nullable, this.fieldGeneratorType, this.defaultValue});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseFieldKey)) {
            return false;
        }
        BaseFieldKey otherKey = (BaseFieldKey)obj;
        return Objects.equals(this.name, otherKey.name) && Objects.equals(this.columnName, otherKey.columnName) && Objects.equals(this.nullable, otherKey.nullable) && Objects.equals((Object)this.fieldGeneratorType, (Object)otherKey.fieldGeneratorType) && Objects.equals(this.defaultValue, otherKey.defaultValue);
    }
}

