/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.field;

import io.datarouter.model.exception.DataAccessException;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldTool;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.string.StringTool;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseField<T>
implements Field<T> {
    private static final Map<Class<?>, Map<String, java.lang.reflect.Field>> CACHED_FIELDS = new ConcurrentHashMap();
    private String prefix;
    protected T value;

    public BaseField(String prefix, T value) {
        this.prefix = StringTool.nullSafe((String)prefix);
        this.value = value;
    }

    @Override
    public int getValueHashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getPrefixedName()) + ":" + this.getValueString();
    }

    @Override
    public void fromString(String valueAsString) {
        this.value = this.parseStringEncodedValueButDoNotSet(valueAsString);
    }

    @Override
    public byte[] getBytesWithSeparator() {
        return this.getBytes();
    }

    @Override
    public T fromBytesWithSeparatorButDoNotSet(byte[] bytes, int byteOffset) {
        return this.fromBytesButDoNotSet(bytes, byteOffset);
    }

    @Override
    public void setUsingReflection(Object targetFieldSet, Object fieldValue) {
        try {
            Object nestedFieldSet = FieldTool.getNestedFieldSet(targetFieldSet, this);
            java.lang.reflect.Field javaField = (java.lang.reflect.Field)CACHED_FIELDS.computeIfAbsent(nestedFieldSet.getClass(), $ -> new ConcurrentHashMap()).get(this.getKey().getName());
            if (javaField == null) {
                javaField = ReflectionTool.getDeclaredFieldFromAncestors(nestedFieldSet.getClass(), (String)this.getKey().getName());
                if (javaField == null) {
                    throw new RuntimeException(String.valueOf(this.getKey().getName()) + " doesn't exist in " + nestedFieldSet.getClass());
                }
                CACHED_FIELDS.get(nestedFieldSet.getClass()).put(this.getKey().getName(), javaField);
            }
            javaField.set(nestedFieldSet, fieldValue);
        }
        catch (Exception e) {
            String message = String.valueOf(e.getClass().getSimpleName()) + " on " + targetFieldSet.getClass().getSimpleName() + "." + this.getKey().getName();
            throw new DataAccessException(message, e);
        }
    }

    @Override
    public String getPrefixedName() {
        if (StringTool.isEmpty((String)this.prefix)) {
            return this.getKey().getName();
        }
        return String.valueOf(this.prefix) + "." + this.getKey().getName();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Field<T> setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public Field<T> setValue(T value) {
        this.value = value;
        return this;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    @Override
    public String getPreparedStatementValue() {
        return "?";
    }

    public static class FieldColumnNameComparator
    implements Comparator<Field<?>> {
        @Override
        public int compare(Field<?> o1, Field<?> o2) {
            return o1.getKey().getColumnName().hashCode() - o2.getKey().getColumnName().hashCode();
        }
    }
}

