/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.entity;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EntityTool {
    public static <EK extends EntityKey<EK>, E extends Entity<EK>> Map<EK, E> getByKey(Collection<E> entities) {
        return entities.stream().collect(Collectors.toMap(Entity::getKey, Function.identity()));
    }

    public static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>> NavigableMap<EK, List<PK>> getPrimaryKeysByEntityKey(Iterable<PK> pks) {
        TreeMap pksByEntityKey = new TreeMap();
        for (EntityPrimaryKey pk : pks) {
            Object ek = pk.getEntityKey();
            ArrayList<EntityPrimaryKey> pksForEntity = (ArrayList<EntityPrimaryKey>)pksByEntityKey.get(ek);
            if (pksForEntity == null) {
                pksForEntity = new ArrayList<EntityPrimaryKey>();
                pksByEntityKey.put(ek, pksForEntity);
            }
            pksForEntity.add(pk);
        }
        return pksByEntityKey;
    }

    public static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> NavigableMap<EK, List<D>> getDatabeansByEntityKey(Iterable<D> databeans) {
        TreeMap databeansByEntityKey = new TreeMap();
        for (Databean databean : databeans) {
            if (databean == null) continue;
            EntityPrimaryKey pk = (EntityPrimaryKey)databean.getKey();
            Object ek = pk.getEntityKey();
            ArrayList<Databean> databeansForEntity = (ArrayList<Databean>)databeansByEntityKey.get(ek);
            if (databeansForEntity == null) {
                databeansForEntity = new ArrayList<Databean>();
                databeansByEntityKey.put(ek, databeansForEntity);
            }
            databeansForEntity.add(databean);
        }
        return databeansByEntityKey;
    }
}

