/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.entity;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class EntitySections<EK extends EntityKey<EK>> {
    private final Map<EntitySection, SortedSet<Object>> backingMap = new HashMap<EntitySection, SortedSet<Object>>();

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> void add(String qualifierPrefix, D databean) {
        this.backingMap.computeIfAbsent(new EntitySection(databean.getClass(), qualifierPrefix), $ -> new TreeSet()).add(databean);
    }

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> void addAll(String qualifierPrefix, Collection<D> databeans) {
        databeans.stream().findFirst().map(Object::getClass).map(databeanClass -> this.backingMap.computeIfAbsent(new EntitySection((Class<?>)databeanClass, qualifierPrefix), $ -> new TreeSet())).ifPresent(section -> {
            boolean bl = section.addAll(databeans);
        });
    }

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> SortedSet<D> get(String qualifierPrefix, Class<D> databeanClass) {
        return this.backingMap.getOrDefault(new EntitySection(databeanClass, qualifierPrefix), Collections.emptySortedSet());
    }

    public long countDatabeans() {
        return this.backingMap.values().stream().mapToInt(Collection::size).sum();
    }

    private static class EntitySection {
        private final Class<?> databeanClass;
        private final String qualifierPrefix;

        private EntitySection(Class<?> databeanClass, String qualifierPrefix) {
            this.databeanClass = databeanClass;
            this.qualifierPrefix = qualifierPrefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntitySection)) {
                return false;
            }
            EntitySection other = (EntitySection)obj;
            return Objects.equals(this.databeanClass, other.databeanClass) && Objects.equals(this.qualifierPrefix, other.qualifierPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.databeanClass, this.qualifierPrefix);
        }
    }
}

