/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.entity;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.entity.EntitySections;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;

public abstract class BaseEntity<EK extends EntityKey<EK>>
implements Entity<EK>,
Comparable<BaseEntity<EK>> {
    private EK key;
    private EntitySections<EK> entitySections;

    public BaseEntity(EK key) {
        this.key = key;
        this.entitySections = new EntitySections();
    }

    @Override
    public void setKey(EK key) {
        this.key = key;
    }

    @Override
    public EK getKey() {
        return this.key;
    }

    @Override
    public int compareTo(BaseEntity<EK> entity) {
        return this.getKey().compareTo(entity.getKey());
    }

    @Override
    public long getNumDatabeans() {
        return this.entitySections.countDatabeans();
    }

    @Override
    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> void addDatabeansForQualifierPrefixUnchecked(String qualifierPrefix, Collection<? extends Databean<?, ?>> databeans) {
        this.addDatabeansForQualifierPrefix(qualifierPrefix, databeans);
    }

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> void addDatabeansForQualifierPrefix(String qualifierPrefix, Collection<D> databeans) {
        this.entitySections.addAll(qualifierPrefix, databeans);
    }

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> SortedSet<D> getDatabeansForQualifierPrefix(Class<D> databeanClass, String qualifierPrefix) {
        return this.entitySections.get(qualifierPrefix, databeanClass);
    }

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> ArrayList<D> getListDatabeansForQualifierPrefix(Class<D> databeanClass, String qualifierPrefix) {
        return new ArrayList<D>(this.getDatabeansForQualifierPrefix(databeanClass, qualifierPrefix));
    }
}

