/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.model.databean;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.util.PercentFieldCodec;
import io.datarouter.util.lang.ClassTool;
import java.util.List;

public abstract class BaseDatabean<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
implements Databean<PK, D> {
    public static final String DEFAULT_KEY_FIELD_NAME = "key";
    private final PK key;

    public BaseDatabean(PK key) {
        this.key = key;
    }

    @Override
    public final PK getKey() {
        return this.key;
    }

    @Override
    public String getDatabeanName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getKeyFieldName() {
        return DEFAULT_KEY_FIELD_NAME;
    }

    @Override
    public List<Field<?>> getKeyFields() {
        return FieldTool.prependPrefixes(this.getKeyFieldName(), this.getKey().getFields());
    }

    public boolean equals(Object obj) {
        if (ClassTool.differentClass((Object)this, (Object)obj)) {
            return false;
        }
        Databean that = (Databean)obj;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public int compareTo(Databean<?, ?> that) {
        int diff = ClassTool.compareClass((Object)this, that);
        if (diff != 0) {
            return diff;
        }
        Databean<?, ?> other = that;
        return this.getKey().compareTo(other.getKey());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + PercentFieldCodec.encodeFields(this.getKey().getFields());
    }
}

