/**
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.model.key.entity.base;

import java.util.function.Function;

import io.datarouter.model.key.entity.EntityKey;

public abstract class BaseByteArrayEntityPartitioner<EK extends EntityKey<EK>>
extends BaseEntityPartitioner<EK>{

	private final Function<byte[],Long> hashMethod;

	public BaseByteArrayEntityPartitioner(Function<byte[],Long> hashMethod, int numPartitions){
		super(numPartitions);
		this.hashMethod = hashMethod;
	}

	protected abstract byte[] makeByteArrayHashInput(EK ek);

	@Override
	public final int getPartition(EK ek){
		byte[] hashInput = makeByteArrayHashInput(ek);
		long hash = hashMethod.apply(hashInput);
		long partition = hash % getNumPartitions();
		return (int)partition;
	}

}
