/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.mockito;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.datarouter.mockito.DefineMock;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.lang.ReflectionTool;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DefineMockSupport {
    public static Module createMockModule(Class<?> testClass) {
        return (Module)Scanner.of((Iterable)ReflectionTool.getDeclaredFieldsIncludingAncestors(testClass)).exclude(field -> Modifier.isStatic(field.getModifiers())).exclude(field -> Modifier.isFinal(field.getModifiers())).exclude(field -> field.getAnnotation(DefineMock.class) == null).listTo(DefineMockSupport::moduleMocking);
    }

    private static Module moduleMocking(final List<Field> fields) {
        return new AbstractModule(){

            protected void configure() {
                for (Field field : fields) {
                    DefineMock annotation = field.getAnnotation(DefineMock.class);
                    Class<?> type = field.getType();
                    MockSettings mockSettings = Mockito.withSettings();
                    if (annotation.extraInterfaces().length > 0) {
                        mockSettings.extraInterfaces((Class[])annotation.extraInterfaces());
                    }
                    if ("".equals(annotation.name())) {
                        mockSettings.name(field.getName());
                    } else {
                        mockSettings.name(annotation.name());
                    }
                    mockSettings.defaultAnswer((Answer)annotation.answer());
                    this.doBind(type, mockSettings);
                }
            }

            private <T> void doBind(Class<T> type, MockSettings mockSettings) {
                Object mock = Mockito.mock(type, (MockSettings)mockSettings);
                this.bind(type).toInstance(mock);
            }
        };
    }
}

