/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.codec.MemcachedDatabeanCodec;
import io.datarouter.client.memcached.codec.MemcachedKey;
import io.datarouter.client.memcached.node.MemcachedBlobNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MemcachedMapStorageNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorage.PhysicalMapStorageNode<PK, D, F> {
    private final Integer schemaVersion;
    private final MemcachedDatabeanCodec<PK, D, F> codec;
    private final MemcachedBlobNode blobNode;

    public MemcachedMapStorageNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedBlobNode blobNode) {
        super(params, clientType);
        this.schemaVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
        this.codec = new MemcachedDatabeanCodec(this.getName(), this.schemaVersion, this.getFieldInfo().getSampleFielder(), this.getFieldInfo().getDatabeanSupplier(), this.getFieldInfo().getFieldByPrefixedName());
        this.blobNode = blobNode;
    }

    public boolean exists(PK key, Config config) {
        return this.scanMultiInternal(List.of(key)).hasAny();
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys).map(Databean::getKey).list();
    }

    public D get(PK key, Config config) {
        return (D)((Databean)this.scanMultiInternal(List.of(key)).findFirst().orElse(null));
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys).list();
    }

    public void delete(PK key, Config config) {
        this.deleteMulti(List.of(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        Scanner.of(keys).map(MemcachedKey::encodeToPathbeanKey).forEach(this.blobNode::delete);
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void put(D databean, Config config) {
        this.putMulti(List.of(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        Scanner.of(databeans).map(this.codec::encodeKeyToPathbeanKeyValueIfValid).concat(OptionalScanner::of).forEach(keyAndValue -> this.blobNode.write((PathbeanKey)keyAndValue.getLeft(), (byte[])keyAndValue.getRight()));
    }

    private Scanner<D> scanMultiInternal(Collection<PK> keys) {
        return Scanner.of(((Map)Scanner.of(keys).map(MemcachedKey::encodeToPathbeanKey).listTo(this.blobNode::read)).values().stream().map(this.codec::decodeBytes));
    }
}

