/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.client.memcached.client.MemcachedClientManager;
import io.datarouter.client.memcached.client.MemcachedOps;
import io.datarouter.client.memcached.codec.MemcachedDatabeanCodec;
import io.datarouter.client.memcached.codec.MemcachedTallyCodec;
import io.datarouter.client.memcached.util.MemcachedExpirationTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.util.tuple.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedNode.class);
    private static final Boolean DEFAULT_IGNORE_EXCEPTION = true;
    private final Integer databeanVersion;
    private final MemcachedOps ops;
    private final ClientId clientId;
    private final MemcachedDatabeanCodec<PK, D, F> codec;
    private final MemcachedTallyCodec tallyCodec;

    public MemcachedNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, MemcachedClientManager memcachedClientManager) {
        super(params, clientType);
        this.ops = new MemcachedOps(memcachedClientManager);
        this.clientId = params.getClientId();
        this.databeanVersion = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
        this.codec = new MemcachedDatabeanCodec(this.getName(), this.databeanVersion, this.getFieldInfo().getSampleFielder(), this.getFieldInfo().getDatabeanSupplier(), this.getFieldInfo().getFieldByPrefixedName());
        this.tallyCodec = new MemcachedTallyCodec(this.getName(), this.databeanVersion);
    }

    public void put(D databean, Config config) {
        this.putMulti(List.of(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        Scanner.of(databeans).map(this.codec::encodeKeyValueIfValid).concat(OptionalScanner::of).forEach(keyAndValue -> this.setInternal((String)keyAndValue.getLeft(), (byte[])keyAndValue.getRight(), config));
    }

    public void delete(PK key, Config config) {
        this.deleteMulti(List.of(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        Scanner.of(keys).map(this.codec::encodeKey).forEach(memcachedStringKey -> this.deleteInternal((String)memcachedStringKey, config));
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public Long incrementAndGetCount(String tallyStringKey, int delta, Config config) {
        String memcachedStringKey = this.tallyCodec.encodeKey(new TallyKey(tallyStringKey));
        int expirationSeconds = MemcachedExpirationTool.getExpirationSeconds(config);
        try {
            return this.ops.increment(this.clientId, memcachedStringKey, delta, expirationSeconds);
        }
        catch (RuntimeException exception) {
            if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                logger.error("memcached error on " + memcachedStringKey, (Throwable)exception);
                return null;
            }
            throw exception;
        }
    }

    public void deleteTally(String tallyStringKey, Config config) {
        String memcachedStringKey = this.tallyCodec.encodeKey(new TallyKey(tallyStringKey));
        this.deleteInternal(memcachedStringKey, config);
    }

    public boolean exists(PK key, Config config) {
        return this.scanMultiInternal(List.of(key), config).hasAny();
    }

    public D get(PK key, Config config) {
        return (D)((Databean)this.scanMultiInternal(List.of(key), config).findFirst().orElse(null));
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys, config).map(Databean::getKey).list();
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.scanMultiInternal(keys, config).list();
    }

    private Scanner<D> scanMultiInternal(Collection<PK> keys, Config config) {
        return ((Scanner)Scanner.of(keys).map(this.codec::encodeKey).listTo(memcachedStringKeys -> this.ops.fetch(this.clientId, this.getName(), (Collection<String>)memcachedStringKeys, config.getTimeout().toMillis(), config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION)))).map(this.codec::decodeResultValue);
    }

    public Optional<Long> findTallyCount(String key, Config config) {
        return Optional.ofNullable(this.getMultiTallyCount(List.of(key), config).get(key));
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> tallyStringKeys, Config config) {
        if (tallyStringKeys.isEmpty()) {
            return Map.of();
        }
        return ((Scanner)Scanner.of(tallyStringKeys).map(TallyKey::new).map(this.tallyCodec::encodeKey).listTo(memcachedStringKeys -> this.ops.fetch(this.clientId, this.getName(), (Collection<String>)memcachedStringKeys, config.getTimeout().toMillis(), config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION)))).map(this.tallyCodec::decodeResult).toMap(Pair::getLeft, Pair::getRight);
    }

    private void setInternal(String memcachedStringKey, byte[] bytes, Config config) {
        int expirationSeconds = MemcachedExpirationTool.getExpirationSeconds(config);
        try {
            this.ops.set(this.clientId, this.getName(), memcachedStringKey, expirationSeconds, bytes);
        }
        catch (Exception exception) {
            if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                logger.error("memcached error on " + memcachedStringKey, (Throwable)exception);
            }
            throw exception;
        }
    }

    private void deleteInternal(String memcachedStringKey, Config config) {
        try {
            this.ops.delete(this.clientId, this.getName(), memcachedStringKey, config.getTimeout());
        }
        catch (Exception exception) {
            if (config.ignoreExceptionOrUse(DEFAULT_IGNORE_EXCEPTION).booleanValue()) {
                logger.error("memcached error on " + memcachedStringKey, (Throwable)exception);
            }
            throw exception;
        }
    }
}

