/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client.options;

import io.datarouter.client.memcached.client.options.MemcachedOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.Properties;

public class MemcachedClientOptionsBuilder
implements ClientOptionsBuilder {
    protected final String clientIdName;
    protected final Properties properties;

    public MemcachedClientOptionsBuilder(ClientId clientId) {
        this(clientId, "memcached");
    }

    protected MemcachedClientOptionsBuilder(ClientId clientId, String clientTypeName) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), clientTypeName);
    }

    public MemcachedClientOptionsBuilder withNumServers(int numberOfServers) {
        String optionKeySuffix = MemcachedOptions.makeMemcachedKey("numServers");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, String.valueOf(numberOfServers));
        return this;
    }

    public MemcachedClientOptionsBuilder withServerIndexAndInetSocketAddress(int serverIndex, String inetSocketAddress) {
        String optionKeySuffix = MemcachedOptions.makeMemcachedKey("server." + serverIndex);
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, inetSocketAddress);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    protected String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

