/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.web;

import io.datarouter.loadtest.service.LoadTestInsertDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.loadtest.storage.RandomValueKey;
import io.datarouter.loadtest.util.LoadTestTool;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.write.StorageWriter;
import io.datarouter.util.concurrent.CallableTool;
import io.datarouter.util.concurrent.ExecutorServiceTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTestInsertHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTestInsertHandler.class);
    private static final String P_num = "num";
    private static final String P_numThreads = "numThreads";
    private static final String P_batchSize = "batchSize";
    private static final String P_logPeriod = "logPeriod";
    private static final String P_persistentPut = "persistentPut";
    private static final String P_submitAction = "submitAction";
    private static final int DEFAULT_NUM = 1000000;
    private static final int DEFAULT_NUM_THREADS = 10;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final boolean DEFAULT_PERSISTENT_PUT = true;
    private static final int DEFAULT_LOG_PERIOD = 10000;
    @Inject
    private LoadTestInsertDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav insert(@Param(value="num") OptionalString num, @Param(value="numThreads") OptionalString numThreads, @Param(value="batchSize") OptionalString batchSize, @Param(value="logPeriod") OptionalString logPeriod, @Param(value="persistentPut") OptionalString persistentPut, @Param(value="submitAction") OptionalString submitAction) {
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Num").withName(P_num).withPlaceholder("100000").withValue((String)num.orElse(null));
        form.addTextField().withDisplay("Num Threads").withName(P_numThreads).withPlaceholder("10").withValue((String)numThreads.orElse(null));
        form.addTextField().withDisplay("Batch Size").withName(P_batchSize).withPlaceholder("100").withValue((String)batchSize.orElse(null));
        form.addTextField().withDisplay("Log Period").withName(P_logPeriod).withPlaceholder("10000").withValue((String)logPeriod.orElse(null));
        form.addTextField().withDisplay("Persistent Put").withName(P_persistentPut).withPlaceholder("true").withValue((String)persistentPut.orElse(null));
        form.addButton().withDisplay("Run Insert").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Load Test - Insert").withContent(Html.makeContent(form)).buildMav();
        }
        int pNum = num.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(1000000);
        int pNumThreads = numThreads.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(10);
        int pBatchSize = batchSize.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(100);
        int pLogPeriod = logPeriod.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(10000);
        boolean pPersistentPut = persistentPut.map(StringTool::nullIfEmpty).map(Boolean::valueOf).orElse(true);
        PhaseTimer timer = new PhaseTimer("insert");
        AtomicInteger counter = new AtomicInteger(0);
        AtomicLong lastBatchFinished = new AtomicLong(System.nanoTime());
        int numBatches = LoadTestTool.numBatches(pNum, pBatchSize);
        ExecutorService executor = Executors.newFixedThreadPool(pNumThreads);
        Scanner.of(IntStream.range(0, numBatches).mapToObj(Integer::valueOf)).map(batchId -> LoadTestTool.makePredictableIdBatch(pNum, pBatchSize, batchId)).map(ids -> new InsertBatchCallable(this.dao.getWriterNode(), (List<Integer>)ids, pPersistentPut, pLogPeriod, lastBatchFinished, counter)).parallel(new ParallelScannerContext(executor, pNumThreads, true)).forEach(CallableTool::callUnchecked);
        ExecutorServiceTool.shutdown((ExecutorService)executor, (Duration)Duration.ofSeconds(5L));
        timer.add("inserted " + counter.get());
        String message = String.valueOf(timer.toString()) + " @" + timer.getItemsPerSecond(counter.get()) + "/s";
        logger.warn(message);
        return this.pageFactory.message(this.request, message);
    }

    private static class Html {
        private Html() {
        }

        public static ContainerTag makeContent(HtmlForm htmlForm) {
            ContainerTag form = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test - Insert"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }

    private static class InsertBatchCallable
    implements Callable<Void> {
        private final StorageWriter<RandomValueKey, RandomValue> node;
        private final List<Integer> ids;
        private final boolean persistentPut;
        private final int logPeriod;
        private final AtomicLong lastBatchFinished;
        private final AtomicInteger counter;

        public InsertBatchCallable(StorageWriter<RandomValueKey, RandomValue> node, List<Integer> ids, boolean persistentPut, int logPeriod, AtomicLong lastBatchFinished, AtomicInteger counter) {
            this.node = node;
            this.ids = ids;
            this.persistentPut = persistentPut;
            this.logPeriod = logPeriod;
            this.lastBatchFinished = lastBatchFinished;
            this.counter = counter;
        }

        @Override
        public Void call() {
            Scanner.of(this.ids).map(RandomValue::new).flush(databeans -> this.node.putMulti((Collection)databeans, new Config().setPersistentPut(Boolean.valueOf(this.persistentPut)).setNumAttempts(Integer.valueOf(10)))).forEach($ -> this.trackEachRow());
            return null;
        }

        private void trackEachRow() {
            int tot = this.counter.incrementAndGet();
            if (tot > 0 && tot % this.logPeriod == 0) {
                long nanoTime = System.nanoTime();
                long durationMs = (nanoTime - this.lastBatchFinished.getAndSet(nanoTime)) / 1000000L;
                double rps = (double)this.logPeriod / (double)durationMs * 1000.0;
                logger.warn("inserted {} @{}rps", (Object)NumberFormatter.addCommas((Number)tot), (Object)NumberFormatter.addCommas((Number)rps));
            }
        }
    }
}

