/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.config;

import io.datarouter.loadtest.config.DatarouterLoadTestPaths;
import io.datarouter.loadtest.config.DatarouterLoadTestRouteSet;
import io.datarouter.loadtest.service.LoadTestGetDao;
import io.datarouter.loadtest.service.LoadTestInsertDao;
import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.DatarouterLoadTestDao;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.List;

public class DatarouterLoadTestPlugin
extends BaseWebPlugin {
    private static final DatarouterLoadTestPaths PATHS = new DatarouterLoadTestPaths();
    private final boolean enableInsert;
    private final boolean enableGet;
    private final boolean enableScan;

    private DatarouterLoadTestPlugin(DatarouterLoadTestDaosModule daosModule, boolean enableInsert, boolean enableGet, boolean enableScan) {
        this.enableInsert = enableInsert;
        this.enableGet = enableGet;
        this.enableScan = enableScan;
        this.addRouteSet(DatarouterLoadTestRouteSet.class);
        if (enableInsert) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.insert, "LoadTest - Insert");
        }
        if (enableGet) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.get, "LoadTest - Get");
        }
        if (enableScan) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.scan, "LoadTest - Scan");
        }
        this.setDaosModule(daosModule);
    }

    public String getName() {
        return "DatarouterLoadTest";
    }

    protected void configure() {
        if (this.enableGet) {
            this.bind(LoadTestGetDao.class).to(DatarouterLoadTestDao.class);
        } else {
            this.bind(LoadTestGetDao.class).to(LoadTestGetDao.NoOpLoadTestGetDao.class);
        }
        if (this.enableInsert) {
            this.bind(LoadTestInsertDao.class).to(DatarouterLoadTestDao.class);
        } else {
            this.bind(LoadTestInsertDao.class).to(LoadTestInsertDao.NoOpLoadTestInsertDao.class);
        }
        if (this.enableScan) {
            this.bind(LoadTestScanDao.class).to(DatarouterLoadTestDao.class);
        } else {
            this.bind(LoadTestScanDao.class).to(LoadTestScanDao.NoOpLoadTestScanDao.class);
        }
    }

    private static class DatarouterLoadTestDaosModule
    extends DaosModuleBuilder {
        private final ClientId defaultClientId;

        private DatarouterLoadTestDaosModule(ClientId defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterLoadTestDao.class);
        }

        protected void configure() {
            this.bind(DatarouterLoadTestDao.LoadTestDaoParams.class).toInstance((Object)new DatarouterLoadTestDao.LoadTestDaoParams(this.defaultClientId));
        }
    }

    public static class DatarouterLoadTestPluginBuilder {
        private final ClientId defaultClientId;
        private boolean enableInsert = false;
        private boolean enableGet = false;
        private boolean enableScan = false;

        public DatarouterLoadTestPluginBuilder(ClientId clientId) {
            this.defaultClientId = clientId;
        }

        public DatarouterLoadTestPluginBuilder enableInsert() {
            this.enableInsert = true;
            return this;
        }

        public DatarouterLoadTestPluginBuilder enableGet() {
            this.enableGet = true;
            return this;
        }

        public DatarouterLoadTestPluginBuilder enableScan() {
            this.enableScan = true;
            return this;
        }

        public DatarouterLoadTestPlugin build() {
            DatarouterLoadTestDaosModule daosModule = new DatarouterLoadTestDaosModule(this.defaultClientId);
            return new DatarouterLoadTestPlugin(daosModule, this.enableInsert, this.enableGet, this.enableScan);
        }
    }
}

